/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.netex.mapping;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.opentripplanner.graph_builder.DataImportIssueStore;
import org.opentripplanner.model.Agency;
import org.opentripplanner.model.FeedScopedId;
import org.opentripplanner.model.FlexLocationGroup;
import org.opentripplanner.model.FlexStopLocation;
import org.opentripplanner.model.Notice;
import org.opentripplanner.model.Route;
import org.opentripplanner.model.ShapePoint;
import org.opentripplanner.model.Station;
import org.opentripplanner.model.StopLocation;
import org.opentripplanner.model.StopPattern;
import org.opentripplanner.model.StopTime;
import org.opentripplanner.model.TransitEntity;
import org.opentripplanner.model.Trip;
import org.opentripplanner.model.TripPattern;
import org.opentripplanner.model.impl.OtpTransitServiceBuilder;
import org.opentripplanner.netex.index.api.NetexEntityIndexReadOnlyView;
import org.opentripplanner.netex.mapping.AuthorityToAgencyMapper;
import org.opentripplanner.netex.mapping.BrandingMapper;
import org.opentripplanner.netex.mapping.FlexStopLocationMapper;
import org.opentripplanner.netex.mapping.GroupNetexMapper;
import org.opentripplanner.netex.mapping.GroupOfStationsMapper;
import org.opentripplanner.netex.mapping.MultiModalStationMapper;
import org.opentripplanner.netex.mapping.NoticeAssignmentMapper;
import org.opentripplanner.netex.mapping.OperatorToAgencyMapper;
import org.opentripplanner.netex.mapping.RouteMapper;
import org.opentripplanner.netex.mapping.ServiceLinkMapper;
import org.opentripplanner.netex.mapping.StopAndStationMapper;
import org.opentripplanner.netex.mapping.TariffZoneMapper;
import org.opentripplanner.netex.mapping.TripCalendarBuilder;
import org.opentripplanner.netex.mapping.TripPatternMapper;
import org.opentripplanner.netex.mapping.TripPatternMapperResult;
import org.opentripplanner.netex.mapping.calendar.CalendarServiceBuilder;
import org.opentripplanner.netex.mapping.calendar.DatedServiceJourneyMapper;
import org.opentripplanner.netex.mapping.support.FeedScopedIdFactory;
import org.opentripplanner.routing.trippattern.Deduplicator;
import org.rutebanken.netex.model.Authority;
import org.rutebanken.netex.model.Branding;
import org.rutebanken.netex.model.FlexibleStopPlace;
import org.rutebanken.netex.model.GroupOfStopPlaces;
import org.rutebanken.netex.model.JourneyPattern;
import org.rutebanken.netex.model.Line;
import org.rutebanken.netex.model.Line_VersionStructure;
import org.rutebanken.netex.model.NoticeAssignment;
import org.rutebanken.netex.model.Operator;
import org.rutebanken.netex.model.StopPlace;

public class NetexMapper {
    private static final int LEVEL_SHARED = 0;
    private static final int LEVEL_GROUP = 1;
    private final FeedScopedIdFactory idFactory;
    private final OtpTransitServiceBuilder transitBuilder;
    private final Deduplicator deduplicator;
    private final DataImportIssueStore issueStore;
    private final Multimap<String, Station> stationsByMultiModalStationRfs = ArrayListMultimap.create();
    private final CalendarServiceBuilder calendarServiceBuilder;
    private final TripCalendarBuilder tripCalendarBuilder;
    private final Set<String> ferryIdsNotAllowedForBicycle;
    private GroupNetexMapper groupMapper;
    private NetexEntityIndexReadOnlyView currentNetexIndex;
    private int level = 0;
    private final Map<String, StopTime> stopTimesByNetexId = new HashMap<String, StopTime>();

    public NetexMapper(OtpTransitServiceBuilder transitBuilder, String feedId, Deduplicator deduplicator, DataImportIssueStore issueStore, Set<String> ferryIdsNotAllowedForBicycle) {
        this.transitBuilder = transitBuilder;
        this.deduplicator = deduplicator;
        this.idFactory = new FeedScopedIdFactory(feedId);
        this.issueStore = issueStore;
        this.ferryIdsNotAllowedForBicycle = ferryIdsNotAllowedForBicycle;
        this.calendarServiceBuilder = new CalendarServiceBuilder(this.idFactory);
        this.tripCalendarBuilder = new TripCalendarBuilder(this.calendarServiceBuilder, issueStore);
    }

    public NetexMapper push() {
        ++this.level;
        this.tripCalendarBuilder.push();
        this.setupGroupMapping();
        return this;
    }

    public NetexMapper pop() {
        this.performGroupMapping();
        this.tripCalendarBuilder.pop();
        --this.level;
        return this;
    }

    public void finnishUp() {
        this.transitBuilder.getCalendarDates().addAll(this.calendarServiceBuilder.createServiceCalendar());
    }

    public void finnishUpGroup() {
        this.transitBuilder.getCalendarDates().addAll(this.calendarServiceBuilder.createServiceCalendar());
    }

    public void mapNetexToOtp(NetexEntityIndexReadOnlyView netexIndex) {
        this.currentNetexIndex = netexIndex;
        this.mapAuthorities();
        this.mapOperators();
        this.mapShapePoints();
        this.mapBrandings();
        TariffZoneMapper tariffZoneMapper = this.mapTariffZones();
        this.mapStopPlaceAndQuays(tariffZoneMapper);
        this.mapMultiModalStopPlaces();
        this.mapGroupsOfStopPlaces();
        this.mapFlexibleStopPlaces();
        this.mapDatedServiceJourneys();
        this.mapDayTypeAssignments();
        Map<String, FeedScopedId> serviceIds = this.createCalendarForServiceJourney();
        this.mapRoute();
        this.mapTripPatterns(serviceIds);
        this.mapNoticeAssignments();
        this.addEntriesToGroupMapperForPostProcessingLater();
    }

    private void setupGroupMapping() {
        if (this.level != 1) {
            return;
        }
        this.groupMapper = new GroupNetexMapper(this.idFactory, this.issueStore, this.transitBuilder);
    }

    private void performGroupMapping() {
        if (this.level != 1) {
            return;
        }
        this.groupMapper.mapGroupEntries();
        this.groupMapper = null;
    }

    private void mapAuthorities() {
        AuthorityToAgencyMapper agencyMapper = new AuthorityToAgencyMapper(this.idFactory, this.currentNetexIndex.getTimeZone());
        for (Authority authority : this.currentNetexIndex.getAuthoritiesById().localValues()) {
            Agency agency = agencyMapper.mapAuthorityToAgency(authority);
            this.transitBuilder.getAgenciesById().add(agency);
        }
    }

    private void mapBrandings() {
        BrandingMapper mapper = new BrandingMapper(this.idFactory);
        for (Branding branding : this.currentNetexIndex.getBrandingById().localValues()) {
            this.transitBuilder.getBrandingsById().add(mapper.mapBranding(branding));
        }
    }

    private void mapOperators() {
        OperatorToAgencyMapper mapper = new OperatorToAgencyMapper(this.idFactory);
        for (Operator operator : this.currentNetexIndex.getOperatorsById().localValues()) {
            this.transitBuilder.getOperatorsById().add(mapper.mapOperator(operator));
        }
    }

    private void mapShapePoints() {
        ServiceLinkMapper serviceLinkMapper = new ServiceLinkMapper(this.idFactory, this.issueStore);
        for (JourneyPattern journeyPattern : this.currentNetexIndex.getJourneyPatternsById().localValues()) {
            Collection<ShapePoint> shapePoints = serviceLinkMapper.getShapePointsByJourneyPattern(journeyPattern, this.currentNetexIndex.getServiceLinkById(), this.currentNetexIndex.getQuayIdByStopPointRef(), this.currentNetexIndex.getQuayById());
            for (ShapePoint shapePoint : shapePoints) {
                this.transitBuilder.getShapePoints().put((Object)shapePoint.getShapeId(), (Object)shapePoint);
            }
        }
    }

    private TariffZoneMapper mapTariffZones() {
        TariffZoneMapper tariffZoneMapper = new TariffZoneMapper(this.getStartOfPeriod(), this.idFactory, this.currentNetexIndex.getTariffZonesById());
        this.transitBuilder.getFareZonesById().addAll(tariffZoneMapper.listAllCurrentFareZones());
        return tariffZoneMapper;
    }

    private void mapStopPlaceAndQuays(TariffZoneMapper tariffZoneMapper) {
        StopAndStationMapper stopMapper = new StopAndStationMapper(this.idFactory, this.currentNetexIndex.getQuayById(), tariffZoneMapper, this.issueStore);
        for (String stopPlaceId : this.currentNetexIndex.getStopPlaceById().localKeys()) {
            Collection<StopPlace> stopPlaceAllVersions = this.currentNetexIndex.getStopPlaceById().lookup(stopPlaceId);
            stopMapper.mapParentAndChildStops(stopPlaceAllVersions);
        }
        this.transitBuilder.getStops().addAll(stopMapper.resultStops);
        this.transitBuilder.getStations().addAll(stopMapper.resultStations);
        this.stationsByMultiModalStationRfs.putAll(stopMapper.resultStationByMultiModalStationRfs);
    }

    private void mapMultiModalStopPlaces() {
        MultiModalStationMapper mapper = new MultiModalStationMapper(this.issueStore, this.idFactory);
        for (StopPlace multiModalStopPlace : this.currentNetexIndex.getMultiModalStopPlaceById().localValues()) {
            this.transitBuilder.getMultiModalStationsById().add(mapper.map(multiModalStopPlace, this.stationsByMultiModalStationRfs.get((Object)multiModalStopPlace.getId())));
        }
    }

    private void mapGroupsOfStopPlaces() {
        GroupOfStationsMapper groupOfStationsMapper = new GroupOfStationsMapper(this.issueStore, this.idFactory, this.transitBuilder.getMultiModalStationsById(), this.transitBuilder.getStations());
        for (GroupOfStopPlaces groupOfStopPlaces : this.currentNetexIndex.getGroupOfStopPlacesById().localValues()) {
            this.transitBuilder.getGroupsOfStationsById().add(groupOfStationsMapper.map(groupOfStopPlaces));
        }
    }

    private void mapFlexibleStopPlaces() {
        Collection flexibleStopPlaces = this.currentNetexIndex.getFlexibleStopPlacesById().localValues();
        if (flexibleStopPlaces.size() == 0) {
            return;
        }
        FlexStopLocationMapper flexStopLocationMapper = new FlexStopLocationMapper(this.idFactory, this.transitBuilder.getStops().values());
        for (FlexibleStopPlace flexibleStopPlace : flexibleStopPlaces) {
            StopLocation stopLocation = flexStopLocationMapper.map(flexibleStopPlace);
            if (stopLocation instanceof FlexStopLocation) {
                this.transitBuilder.getLocations().add((FlexStopLocation)stopLocation);
                continue;
            }
            if (!(stopLocation instanceof FlexLocationGroup)) continue;
            this.transitBuilder.getLocationGroups().add((FlexLocationGroup)stopLocation);
        }
    }

    private void mapDatedServiceJourneys() {
        this.tripCalendarBuilder.addDatedServiceJourneys(this.currentNetexIndex.getOperatingDayById(), DatedServiceJourneyMapper.indexDSJBySJId(this.currentNetexIndex.getDatedServiceJourneys()));
    }

    private void mapDayTypeAssignments() {
        this.tripCalendarBuilder.addDayTypeAssignments(this.currentNetexIndex.getDayTypeById(), this.currentNetexIndex.getDayTypeAssignmentByDayTypeId(), this.currentNetexIndex.getOperatingDayById(), this.currentNetexIndex.getOperatingPeriodById());
    }

    private Map<String, FeedScopedId> createCalendarForServiceJourney() {
        return this.tripCalendarBuilder.createTripCalendar(this.currentNetexIndex.getServiceJourneyById().localValues());
    }

    private void mapRoute() {
        Route route;
        RouteMapper routeMapper = new RouteMapper(this.issueStore, this.idFactory, this.transitBuilder.getAgenciesById(), this.transitBuilder.getOperatorsById(), this.transitBuilder.getBrandingsById(), this.currentNetexIndex, this.currentNetexIndex.getTimeZone(), this.ferryIdsNotAllowedForBicycle);
        for (Line line : this.currentNetexIndex.getLineById().localValues()) {
            route = routeMapper.mapRoute((Line_VersionStructure)line);
            this.transitBuilder.getRoutes().add(route);
        }
        for (Line line : this.currentNetexIndex.getFlexibleLineById().localValues()) {
            route = routeMapper.mapRoute((Line_VersionStructure)line);
            this.transitBuilder.getRoutes().add(route);
        }
    }

    private void mapTripPatterns(Map<String, FeedScopedId> serviceIds) {
        TripPatternMapper tripPatternMapper = new TripPatternMapper(this.issueStore, this.idFactory, this.transitBuilder.getOperatorsById(), this.transitBuilder.getStops(), this.transitBuilder.getLocations(), this.transitBuilder.getLocationGroups(), this.transitBuilder.getRoutes(), this.transitBuilder.getShapePoints().keySet(), this.currentNetexIndex.getRouteById(), this.currentNetexIndex.getJourneyPatternsById(), this.currentNetexIndex.getQuayIdByStopPointRef(), this.currentNetexIndex.getFlexibleStopPlaceByStopPointRef(), this.currentNetexIndex.getDestinationDisplayById(), this.currentNetexIndex.getServiceJourneyById(), this.currentNetexIndex.getFlexibleLineById(), serviceIds, this.deduplicator);
        for (JourneyPattern journeyPattern : this.currentNetexIndex.getJourneyPatternsById().localValues()) {
            TripPatternMapperResult result = tripPatternMapper.mapTripPattern(journeyPattern);
            for (Map.Entry<Trip, List<StopTime>> it : result.tripStopTimes.entrySet()) {
                this.transitBuilder.getStopTimesSortedByTrip().put(it.getKey(), (Collection<StopTime>)it.getValue());
                this.transitBuilder.getTripsById().add(it.getKey());
            }
            for (Map.Entry<Trip, List<StopTime>> it : result.tripPatterns.entries()) {
                this.transitBuilder.getTripPatterns().put((Object)((StopPattern)((Object)it.getKey())), (Object)((TripPattern)((Object)it.getValue())));
            }
            this.stopTimesByNetexId.putAll(result.stopTimeByNetexId);
            this.groupMapper.scheduledStopPointsIndex.putAll(result.scheduledStopPointsIndex);
        }
    }

    private void mapNoticeAssignments() {
        NoticeAssignmentMapper noticeAssignmentMapper = new NoticeAssignmentMapper(this.issueStore, this.idFactory, this.currentNetexIndex.getServiceJourneyById().localValues(), this.currentNetexIndex.getNoticeById(), this.transitBuilder.getRoutes(), this.transitBuilder.getTripsById(), this.stopTimesByNetexId);
        for (NoticeAssignment noticeAssignment : this.currentNetexIndex.getNoticeAssignmentById().localValues()) {
            Multimap<TransitEntity, Notice> noticesByElementId = noticeAssignmentMapper.map(noticeAssignment);
            this.transitBuilder.getNoticeAssignments().putAll(noticesByElementId);
        }
    }

    private void addEntriesToGroupMapperForPostProcessingLater() {
        if (this.level != 0) {
            this.groupMapper.addInterchange(this.currentNetexIndex.getServiceJourneyInterchangeById().localValues());
        }
    }

    private LocalDateTime getStartOfPeriod() {
        String timeZone = this.currentNetexIndex.getTimeZone();
        if (timeZone == null) {
            LocalDateTime time = LocalDateTime.now(ZoneId.of("UTC"));
            this.issueStore.add("NetexImportTimeZone", "No timezone set for the current NeTEx input data file. The import start-of-period is set to " + time + " UTC, used to check entity validity periods.");
            return time;
        }
        return LocalDateTime.now(ZoneId.of(timeZone));
    }
}

