/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.netex.mapping;

import java.util.Collection;
import java.util.Optional;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Point;
import org.opentripplanner.common.geometry.GeometryUtils;
import org.opentripplanner.common.geometry.HashGridSpatialIndex;
import org.opentripplanner.model.FlexLocationGroup;
import org.opentripplanner.model.FlexStopLocation;
import org.opentripplanner.model.Stop;
import org.opentripplanner.model.StopLocation;
import org.opentripplanner.netex.mapping.OpenGisMapper;
import org.opentripplanner.netex.mapping.support.FeedScopedIdFactory;
import org.rutebanken.netex.model.FlexibleArea;
import org.rutebanken.netex.model.FlexibleStopPlace;
import org.rutebanken.netex.model.KeyValueStructure;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class FlexStopLocationMapper {
    private static final Logger LOG = LoggerFactory.getLogger(FlexStopLocationMapper.class);
    private final FeedScopedIdFactory idFactory;
    private final HashGridSpatialIndex<Stop> stopsSpatialIndex;
    private static final String FLEXIBLE_STOP_AREA_TYPE_KEY = "FlexibleStopAreaType";
    private static final String UNRESTRICTED_PUBLIC_TRANSPORT_AREAS_VALUE = "UnrestrictedPublicTransportAreas";

    FlexStopLocationMapper(FeedScopedIdFactory idFactory, Collection<Stop> stops) {
        this.idFactory = idFactory;
        this.stopsSpatialIndex = new HashGridSpatialIndex();
        for (Stop stop : stops) {
            Envelope env = new Envelope(stop.getCoordinate().asJtsCoordinate());
            this.stopsSpatialIndex.insert(env, (Object)stop);
        }
    }

    StopLocation map(FlexibleStopPlace flexibleStopPlace) {
        Object area = flexibleStopPlace.getAreas().getFlexibleAreaOrFlexibleAreaRefOrHailAndRideArea().get(0);
        if (!(area instanceof FlexibleArea)) {
            LOG.warn("FlexibleStopPlace {} not mapped. Hail and ride areas are not currently supported.", (Object)flexibleStopPlace.getId());
            return null;
        }
        Optional<Object> flexibleAreaType = Optional.empty();
        if (flexibleStopPlace.getKeyList() != null) {
            flexibleAreaType = flexibleStopPlace.getKeyList().getKeyValue().stream().filter(k -> k.getKey().equals(FLEXIBLE_STOP_AREA_TYPE_KEY)).findFirst();
        }
        if (flexibleAreaType.isPresent() && ((KeyValueStructure)flexibleAreaType.get()).getValue().equals(UNRESTRICTED_PUBLIC_TRANSPORT_AREAS_VALUE)) {
            return this.mapStopsInFlexArea(flexibleStopPlace, (FlexibleArea)area);
        }
        return this.mapFlexArea(flexibleStopPlace, (FlexibleArea)area);
    }

    FlexStopLocation mapFlexArea(FlexibleStopPlace flexibleStopPlace, FlexibleArea area) {
        FlexStopLocation result = new FlexStopLocation(this.idFactory.createId(flexibleStopPlace.getId()));
        result.setName(flexibleStopPlace.getName().getValue());
        result.setGeometry(OpenGisMapper.mapGeometry(area.getPolygon()));
        return result;
    }

    FlexLocationGroup mapStopsInFlexArea(FlexibleStopPlace flexibleStopPlace, FlexibleArea area) {
        FlexLocationGroup result = new FlexLocationGroup(this.idFactory.createId(flexibleStopPlace.getId()));
        result.setName(flexibleStopPlace.getName().getValue());
        Geometry geometry = OpenGisMapper.mapGeometry(area.getPolygon());
        for (Stop stop : this.stopsSpatialIndex.query(geometry.getEnvelopeInternal())) {
            Point p = GeometryUtils.getGeometryFactory().createPoint(stop.getCoordinate().asJtsCoordinate());
            if (!geometry.contains((Geometry)p)) continue;
            result.addLocation(stop);
        }
        return result;
    }
}

