/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.netex.mapping;

import org.opentripplanner.model.Agency;
import org.opentripplanner.netex.mapping.support.FeedScopedIdFactory;
import org.opentripplanner.netex.mapping.support.NetexObjectDecorator;
import org.rutebanken.netex.model.Authority;

class AuthorityToAgencyMapper {
    private final FeedScopedIdFactory idFactory;
    private final String timeZone;
    private final String dummyAgencyId;

    AuthorityToAgencyMapper(FeedScopedIdFactory idFactory, String timeZone) {
        this.idFactory = idFactory;
        this.timeZone = timeZone;
        this.dummyAgencyId = "Dummy-" + timeZone;
    }

    Agency mapAuthorityToAgency(Authority source) {
        Agency target = new Agency(this.idFactory.createId(source.getId()), source.getName().getValue(), this.timeZone);
        NetexObjectDecorator.withOptional(source.getContactDetails(), c -> {
            target.setUrl(c.getUrl());
            target.setPhone(c.getPhone());
        });
        return target;
    }

    Agency createDummyAgency() {
        Agency agency = new Agency(this.idFactory.createId(this.dummyAgencyId), "N/A", this.timeZone);
        agency.setUrl("N/A");
        agency.setPhone("N/A");
        return agency;
    }

    String dummyAgencyId() {
        return this.dummyAgencyId;
    }
}

