/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.netex.loader.parser;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.JAXBElement;
import org.opentripplanner.netex.index.NetexEntityIndex;
import org.opentripplanner.netex.index.api.ReadOnlyHierarchicalMapById;
import org.opentripplanner.netex.loader.parser.NetexParser;
import org.opentripplanner.netex.loader.parser.NoticeParser;
import org.opentripplanner.util.OTPFeature;
import org.opentripplanner.util.logging.MaxCountLogger;
import org.rutebanken.netex.model.DestinationDisplay;
import org.rutebanken.netex.model.DestinationDisplaysInFrame_RelStructure;
import org.rutebanken.netex.model.FlexibleLine;
import org.rutebanken.netex.model.FlexibleStopAssignment;
import org.rutebanken.netex.model.FlexibleStopPlace;
import org.rutebanken.netex.model.GroupOfLines;
import org.rutebanken.netex.model.GroupsOfLinesInFrame_RelStructure;
import org.rutebanken.netex.model.JourneyPattern;
import org.rutebanken.netex.model.JourneyPatternsInFrame_RelStructure;
import org.rutebanken.netex.model.Line;
import org.rutebanken.netex.model.LinesInFrame_RelStructure;
import org.rutebanken.netex.model.Network;
import org.rutebanken.netex.model.NetworksInFrame_RelStructure;
import org.rutebanken.netex.model.PassengerStopAssignment;
import org.rutebanken.netex.model.Route;
import org.rutebanken.netex.model.RoutesInFrame_RelStructure;
import org.rutebanken.netex.model.ScheduledStopPointRefStructure;
import org.rutebanken.netex.model.ServiceLink;
import org.rutebanken.netex.model.ServiceLinksInFrame_RelStructure;
import org.rutebanken.netex.model.Service_VersionFrameStructure;
import org.rutebanken.netex.model.StopAssignmentsInFrame_RelStructure;
import org.rutebanken.netex.model.VersionFrame_VersionStructure;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ServiceFrameParser
extends NetexParser<Service_VersionFrameStructure> {
    private static final Logger LOG = LoggerFactory.getLogger(ServiceFrameParser.class);
    private static final MaxCountLogger PASSENGER_STOP_ASSIGNMENT_LOGGER = MaxCountLogger.maxCount(LOG);
    private final ReadOnlyHierarchicalMapById<FlexibleStopPlace> flexibleStopPlaceById;
    private final Collection<Network> networks = new ArrayList<Network>();
    private final Collection<GroupOfLines> groupOfLines = new ArrayList<GroupOfLines>();
    private final Collection<Route> routes = new ArrayList<Route>();
    private final Collection<FlexibleLine> flexibleLines = new ArrayList<FlexibleLine>();
    private final Collection<Line> lines = new ArrayList<Line>();
    private final Map<String, String> networkIdByGroupOfLineId = new HashMap<String, String>();
    private final Collection<JourneyPattern> journeyPatterns = new ArrayList<JourneyPattern>();
    private final Collection<DestinationDisplay> destinationDisplays = new ArrayList<DestinationDisplay>();
    private final Map<String, String> quayIdByStopPointRef = new HashMap<String, String>();
    private final Map<String, String> flexibleStopPlaceByStopPointRef = new HashMap<String, String>();
    private final Collection<ServiceLink> serviceLinks = new ArrayList<ServiceLink>();
    private final NoticeParser noticeParser = new NoticeParser();

    ServiceFrameParser(ReadOnlyHierarchicalMapById<FlexibleStopPlace> flexibleStopPlaceById) {
        this.flexibleStopPlaceById = flexibleStopPlaceById;
    }

    @Override
    void parse(Service_VersionFrameStructure frame) {
        this.parseStopAssignments(frame.getStopAssignments());
        this.parseRoutes(frame.getRoutes());
        this.parseNetwork(frame.getNetwork());
        this.parseAdditionalNetworks(frame.getAdditionalNetworks());
        this.noticeParser.parseNotices(frame.getNotices());
        this.noticeParser.parseNoticeAssignments(frame.getNoticeAssignments());
        this.parseLines(frame.getLines());
        this.parseJourneyPatterns(frame.getJourneyPatterns());
        this.parseDestinationDisplays(frame.getDestinationDisplays());
        this.parseServiceLinks(frame.getServiceLinks());
        ServiceFrameParser.warnOnMissingMapping(LOG, frame.getAdditionalNetworks());
        ServiceFrameParser.warnOnMissingMapping(LOG, frame.getCommonSections());
        ServiceFrameParser.warnOnMissingMapping(LOG, frame.getConnections());
        ServiceFrameParser.warnOnMissingMapping(LOG, frame.getDirections());
        ServiceFrameParser.warnOnMissingMapping(LOG, frame.getDisplayAssignments());
        ServiceFrameParser.warnOnMissingMapping(LOG, frame.getFlexibleLinkProperties());
        ServiceFrameParser.warnOnMissingMapping(LOG, frame.getFlexiblePointProperties());
        ServiceFrameParser.warnOnMissingMapping(LOG, frame.getGeneralSections());
        ServiceFrameParser.warnOnMissingMapping(LOG, frame.getGroupsOfLines());
        ServiceFrameParser.warnOnMissingMapping(LOG, frame.getGroupsOfLinks());
        ServiceFrameParser.warnOnMissingMapping(LOG, frame.getGroupsOfPoints());
        ServiceFrameParser.warnOnMissingMapping(LOG, frame.getLineNetworks());
        ServiceFrameParser.warnOnMissingMapping(LOG, frame.getLogicalDisplays());
        ServiceFrameParser.warnOnMissingMapping(LOG, frame.getPassengerInformationEquipments());
        ServiceFrameParser.warnOnMissingMapping(LOG, frame.getRouteLinks());
        ServiceFrameParser.warnOnMissingMapping(LOG, frame.getRoutePoints());
        ServiceFrameParser.warnOnMissingMapping(LOG, frame.getRoutingConstraintZones());
        ServiceFrameParser.warnOnMissingMapping(LOG, frame.getScheduledStopPoints());
        ServiceFrameParser.warnOnMissingMapping(LOG, frame.getServiceExclusions());
        ServiceFrameParser.warnOnMissingMapping(LOG, frame.getServicePatterns());
        ServiceFrameParser.warnOnMissingMapping(LOG, frame.getStopAreas());
        ServiceFrameParser.warnOnMissingMapping(LOG, frame.getTariffZones());
        ServiceFrameParser.warnOnMissingMapping(LOG, frame.getTimeDemandTypes());
        ServiceFrameParser.warnOnMissingMapping(LOG, frame.getTimeDemandTypeAssignments());
        ServiceFrameParser.warnOnMissingMapping(LOG, frame.getTimingPoints());
        ServiceFrameParser.warnOnMissingMapping(LOG, frame.getTimingLinks());
        ServiceFrameParser.warnOnMissingMapping(LOG, frame.getTimingLinkGroups());
        ServiceFrameParser.warnOnMissingMapping(LOG, frame.getTimingPatterns());
        ServiceFrameParser.warnOnMissingMapping(LOG, frame.getTransferRestrictions());
        ServiceFrameParser.verifyCommonUnusedPropertiesIsNotSet(LOG, (VersionFrame_VersionStructure)frame);
    }

    @Override
    void setResultOnIndex(NetexEntityIndex index) {
        index.destinationDisplayById.addAll(this.destinationDisplays);
        index.groupOfLinesById.addAll(this.groupOfLines);
        index.journeyPatternsById.addAll(this.journeyPatterns);
        index.flexibleLineByid.addAll(this.flexibleLines);
        index.lineById.addAll(this.lines);
        index.networkById.addAll(this.networks);
        this.noticeParser.setResultOnIndex(index);
        index.quayIdByStopPointRef.addAll(this.quayIdByStopPointRef);
        index.flexibleStopPlaceByStopPointRef.addAll(this.flexibleStopPlaceByStopPointRef);
        index.routeById.addAll(this.routes);
        index.serviceLinkById.addAll(this.serviceLinks);
        index.networkIdByGroupOfLineId.addAll(this.networkIdByGroupOfLineId);
    }

    static void logSummary() {
        PASSENGER_STOP_ASSIGNMENT_LOGGER.logTotal("PassengerStopAssignment with empty quay ref.");
    }

    private void parseStopAssignments(StopAssignmentsInFrame_RelStructure stopAssignments) {
        if (stopAssignments == null) {
            return;
        }
        for (JAXBElement stopAssignment : stopAssignments.getStopAssignment()) {
            PassengerStopAssignment assignment;
            if (stopAssignment.getValue() instanceof PassengerStopAssignment) {
                assignment = (PassengerStopAssignment)stopAssignment.getValue();
                if (assignment.getQuayRef() == null) {
                    PASSENGER_STOP_ASSIGNMENT_LOGGER.info("PassengerStopAssignment with empty quay ref is dropped. Assigment: {}", (Object)assignment.getId());
                    continue;
                }
                String quayRef = assignment.getQuayRef().getRef();
                String stopPointRef = ((ScheduledStopPointRefStructure)assignment.getScheduledStopPointRef().getValue()).getRef();
                this.quayIdByStopPointRef.put(stopPointRef, quayRef);
                continue;
            }
            if (stopAssignment.getValue() instanceof FlexibleStopAssignment) {
                if (!OTPFeature.FlexRouting.isOn()) continue;
                assignment = (FlexibleStopAssignment)stopAssignment.getValue();
                String flexibleStopPlaceRef = assignment.getFlexibleStopPlaceRef().getRef();
                FlexibleStopPlace flexibleStopPlace = (FlexibleStopPlace)this.flexibleStopPlaceById.lookup(flexibleStopPlaceRef);
                if (flexibleStopPlace != null) {
                    String stopPointRef = ((ScheduledStopPointRefStructure)assignment.getScheduledStopPointRef().getValue()).getRef();
                    this.flexibleStopPlaceByStopPointRef.put(stopPointRef, flexibleStopPlace.getId());
                    continue;
                }
                LOG.warn("FlexibleStopPlace {} not found in stop place file.", (Object)flexibleStopPlaceRef);
                continue;
            }
            ServiceFrameParser.warnOnMissingMapping(LOG, stopAssignment.getValue());
        }
    }

    private void parseRoutes(RoutesInFrame_RelStructure routes) {
        if (routes == null) {
            return;
        }
        for (JAXBElement element : routes.getRoute_()) {
            if (!(element.getValue() instanceof Route)) continue;
            Route route = (Route)element.getValue();
            this.routes.add(route);
        }
    }

    private void parseNetwork(Network network) {
        if (network == null) {
            return;
        }
        this.networks.add(network);
        GroupsOfLinesInFrame_RelStructure groupsOfLines = network.getGroupsOfLines();
        if (groupsOfLines != null) {
            this.parseGroupOfLines(groupsOfLines.getGroupOfLines(), network);
        }
    }

    private void parseAdditionalNetworks(NetworksInFrame_RelStructure additionalNetworks) {
        if (additionalNetworks == null) {
            return;
        }
        for (Network additionalNetwork : additionalNetworks.getNetwork()) {
            this.parseNetwork(additionalNetwork);
        }
    }

    private void parseGroupOfLines(Collection<GroupOfLines> groupOfLines, Network network) {
        for (GroupOfLines group : groupOfLines) {
            this.networkIdByGroupOfLineId.put(group.getId(), network.getId());
            this.groupOfLines.add(group);
        }
    }

    private void parseLines(LinesInFrame_RelStructure lines) {
        if (lines == null) {
            return;
        }
        for (JAXBElement element : lines.getLine_()) {
            if (element.getValue() instanceof Line) {
                this.lines.add((Line)element.getValue());
                continue;
            }
            if (element.getValue() instanceof FlexibleLine) {
                if (!OTPFeature.FlexRouting.isOn()) continue;
                this.flexibleLines.add((FlexibleLine)element.getValue());
                continue;
            }
            ServiceFrameParser.warnOnMissingMapping(LOG, element.getValue());
        }
    }

    private void parseJourneyPatterns(JourneyPatternsInFrame_RelStructure journeyPatterns) {
        if (journeyPatterns == null) {
            return;
        }
        for (JAXBElement pattern : journeyPatterns.getJourneyPattern_OrJourneyPatternView()) {
            if (pattern.getValue() instanceof JourneyPattern) {
                this.journeyPatterns.add((JourneyPattern)pattern.getValue());
                continue;
            }
            ServiceFrameParser.warnOnMissingMapping(LOG, pattern.getValue());
        }
    }

    private void parseDestinationDisplays(DestinationDisplaysInFrame_RelStructure destDisplays) {
        if (destDisplays == null) {
            return;
        }
        this.destinationDisplays.addAll(destDisplays.getDestinationDisplay());
    }

    private void parseServiceLinks(ServiceLinksInFrame_RelStructure serviceLinks) {
        if (serviceLinks == null) {
            return;
        }
        this.serviceLinks.addAll(serviceLinks.getServiceLink());
    }
}

