/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.netex.loader.parser;

import java.util.List;
import javax.xml.bind.JAXBElement;
import org.opentripplanner.netex.index.NetexEntityIndex;
import org.opentripplanner.netex.loader.parser.NetexParser;
import org.opentripplanner.netex.loader.parser.ResourceFrameParser;
import org.opentripplanner.netex.loader.parser.ServiceCalendarFrameParser;
import org.opentripplanner.netex.loader.parser.ServiceFrameParser;
import org.opentripplanner.netex.loader.parser.SiteFrameParser;
import org.opentripplanner.netex.loader.parser.TimeTableFrameParser;
import org.rutebanken.netex.model.Common_VersionFrameStructure;
import org.rutebanken.netex.model.CompositeFrame;
import org.rutebanken.netex.model.GeneralFrame;
import org.rutebanken.netex.model.InfrastructureFrame;
import org.rutebanken.netex.model.PublicationDeliveryStructure;
import org.rutebanken.netex.model.ResourceFrame;
import org.rutebanken.netex.model.ServiceCalendarFrame;
import org.rutebanken.netex.model.ServiceFrame;
import org.rutebanken.netex.model.SiteFrame;
import org.rutebanken.netex.model.TimetableFrame;
import org.rutebanken.netex.model.VersionFrameDefaultsStructure;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetexDocumentParser {
    private static final Logger LOG = LoggerFactory.getLogger(NetexDocumentParser.class);
    private final NetexEntityIndex netexIndex;

    private NetexDocumentParser(NetexEntityIndex netexIndex) {
        this.netexIndex = netexIndex;
    }

    public static void parseAndPopulateIndex(NetexEntityIndex index, PublicationDeliveryStructure doc) {
        new NetexDocumentParser(index).parse(doc);
    }

    public static void finnishUp() {
        ServiceFrameParser.logSummary();
    }

    private void parse(PublicationDeliveryStructure doc) {
        this.parseFrameList(doc.getDataObjects().getCompositeFrameOrCommonFrame());
    }

    private void parseFrameList(List<JAXBElement<? extends Common_VersionFrameStructure>> frames) {
        for (JAXBElement<? extends Common_VersionFrameStructure> frame : frames) {
            this.parseCommonFrame((Common_VersionFrameStructure)frame.getValue());
        }
    }

    private void parseCommonFrame(Common_VersionFrameStructure value) {
        if (value instanceof ResourceFrame) {
            this.parse((ResourceFrame)value, new ResourceFrameParser());
        } else if (value instanceof ServiceCalendarFrame) {
            this.parse((ServiceCalendarFrame)value, new ServiceCalendarFrameParser());
        } else if (value instanceof TimetableFrame) {
            this.parse((TimetableFrame)value, new TimeTableFrameParser());
        } else if (value instanceof ServiceFrame) {
            this.parse((ServiceFrame)value, new ServiceFrameParser(this.netexIndex.flexibleStopPlaceById));
        } else if (value instanceof SiteFrame) {
            this.parse((SiteFrame)value, new SiteFrameParser());
        } else if (value instanceof CompositeFrame) {
            this.parseCompositeFrame((CompositeFrame)value);
        } else if (value instanceof GeneralFrame || value instanceof InfrastructureFrame) {
            NetexParser.informOnElementIntentionallySkipped(LOG, value);
        } else {
            NetexParser.warnOnMissingMapping(LOG, value);
        }
    }

    private void parseCompositeFrame(CompositeFrame frame) {
        this.parseFrameDefaultsLikeTimeZone(frame.getFrameDefaults());
        List frames = frame.getFrames().getCommonFrame();
        for (JAXBElement it : frames) {
            this.parseCommonFrame((Common_VersionFrameStructure)it.getValue());
        }
    }

    private void parseFrameDefaultsLikeTimeZone(VersionFrameDefaultsStructure frameDefaults) {
        String timeZone = "GMT";
        if (frameDefaults != null && frameDefaults.getDefaultLocale() != null && frameDefaults.getDefaultLocale().getTimeZone() != null) {
            timeZone = frameDefaults.getDefaultLocale().getTimeZone();
        }
        this.netexIndex.timeZone.set(timeZone);
    }

    private <T> void parse(T node, NetexParser<T> parser) {
        parser.parse(node);
        parser.setResultOnIndex(this.netexIndex);
    }
}

