/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.netex.loader;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.opentripplanner.datastore.CompositeDataSource;
import org.opentripplanner.datastore.DataSource;
import org.opentripplanner.netex.loader.GroupEntries;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetexDataSourceHierarchy {
    private static final Logger LOG = LoggerFactory.getLogger(NetexDataSourceHierarchy.class);
    private final CompositeDataSource source;
    private final List<DataSource> sharedEntries = new ArrayList<DataSource>();
    private final Map<String, GroupEntries> groupEntries = new TreeMap<String, GroupEntries>();

    public NetexDataSourceHierarchy(CompositeDataSource source) {
        this.source = source;
    }

    public NetexDataSourceHierarchy prepare(Pattern ignoreFilePattern, Pattern sharedFilePattern, Pattern sharedGroupFilePattern, Pattern groupFilePattern) {
        new DistributeEntries(ignoreFilePattern, sharedFilePattern, sharedGroupFilePattern, groupFilePattern).execute();
        return this;
    }

    public String description() {
        return this.source.path();
    }

    public Iterable<DataSource> sharedEntries() {
        return this.sharedEntries;
    }

    public Iterable<GroupEntries> groups() {
        return this.groupEntries.values();
    }

    private class DistributeEntries {
        private final Pattern ignoreFilePattern;
        private final Pattern sharedFilePattern;
        private final Pattern sharedGroupFilePattern;
        private final Pattern groupFilePattern;
        private String currentGroup = null;

        private DistributeEntries(Pattern ignoreFilePattern, Pattern sharedFilePattern, Pattern sharedGroupFilePattern, Pattern groupFilePattern) {
            this.ignoreFilePattern = ignoreFilePattern;
            this.sharedFilePattern = sharedFilePattern;
            this.sharedGroupFilePattern = sharedGroupFilePattern;
            this.groupFilePattern = groupFilePattern;
        }

        private void execute() {
            for (DataSource entry : NetexDataSourceHierarchy.this.source.content()) {
                String name = entry.name();
                if (this.ignoredFile(name)) {
                    LOG.debug("Netex file ignored: {}.", (Object)name);
                    continue;
                }
                if (this.isSharedFile(name)) {
                    NetexDataSourceHierarchy.this.sharedEntries.add(entry);
                    continue;
                }
                if (this.isGroupEntry(name, this.sharedGroupFilePattern)) {
                    NetexDataSourceHierarchy.this.groupEntries.get(this.currentGroup).addSharedEntry(entry);
                    continue;
                }
                if (this.isGroupEntry(name, this.groupFilePattern)) {
                    NetexDataSourceHierarchy.this.groupEntries.get(this.currentGroup).addIndependentEntries(entry);
                    continue;
                }
                LOG.warn("Netex file ignored: {}. The file do not match any file patterns in the config.", (Object)name);
            }
        }

        private boolean ignoredFile(String name) {
            return this.ignoreFilePattern.matcher(name).matches();
        }

        private boolean isSharedFile(String name) {
            return this.sharedFilePattern.matcher(name).matches();
        }

        private boolean isGroupEntry(String name, Pattern filePattern) {
            Matcher m = filePattern.matcher(name);
            if (!m.matches()) {
                return false;
            }
            try {
                this.currentGroup = m.group(1);
            }
            catch (IndexOutOfBoundsException e) {
                throw new IllegalStateException("Netex file patten '" + filePattern + "' is missing a group pattern like: '(\\w+)' in '(\\w+)-.*\\.xml' ");
            }
            NetexDataSourceHierarchy.this.groupEntries.computeIfAbsent(this.currentGroup, GroupEntries::new);
            return true;
        }
    }
}

