/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.netex.index.hierarchy;

import com.google.common.collect.Multimap;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.Objects;
import java.util.stream.Collectors;
import org.opentripplanner.netex.index.api.ReadOnlyHierarchicalVersionMapById;
import org.opentripplanner.netex.index.hierarchy.HierarchicalMultimap;
import org.opentripplanner.netex.index.hierarchy.ValidOnDate;
import org.opentripplanner.netex.support.NetexVersionHelper;
import org.rutebanken.netex.model.EntityInVersionStructure;
import org.rutebanken.netex.model.VersionOfObjectRefStructure;

public class HierarchicalVersionMapById<V extends EntityInVersionStructure>
extends HierarchicalMultimap<String, V>
implements ReadOnlyHierarchicalVersionMapById<V> {
    public HierarchicalVersionMapById() {
    }

    public HierarchicalVersionMapById(HierarchicalVersionMapById<V> parent) {
        super(parent);
    }

    @Override
    public HierarchicalVersionMapById<V> parent() {
        return (HierarchicalVersionMapById)super.parent();
    }

    public void add(V entity) {
        super.add(entity.getId(), entity);
    }

    public void addAll(Collection<V> entities) {
        for (EntityInVersionStructure it : entities) {
            this.add(it);
        }
    }

    @Override
    public Collection<String> localKeys() {
        return super.localKeys();
    }

    @Override
    public void add(String key, V value) {
        throw new IllegalArgumentException("Use the add method with just one argument instead.");
    }

    @Override
    public void addAll(Multimap<String, V> other) {
        throw new IllegalArgumentException("Use the add method with just one argument instead.");
    }

    @Override
    public V lookupLastVersionById(String id) {
        return (V)NetexVersionHelper.latestVersionedElementIn((Collection)this.lookup(id));
    }

    @Override
    public V lookup(VersionOfObjectRefStructure ref, LocalDateTime timestamp) {
        String id = ref.getRef();
        String version = ref.getVersion();
        Collection list = (Collection)this.lookup(id);
        if (list.isEmpty()) {
            return null;
        }
        if (version != null) {
            for (EntityInVersionStructure value : list) {
                if (!version.equals(value.getVersion())) continue;
                return (V)value;
            }
        }
        return this.firstValidBestVersion(list, timestamp);
    }

    @Override
    public Collection<V> localListCurrentVersionEntities(LocalDateTime timestamp) {
        return this.localValues().stream().map(c -> this.firstValidBestVersion((Collection<V>)c, timestamp)).filter(Objects::nonNull).collect(Collectors.toUnmodifiableList());
    }

    @Override
    public boolean isNewerOrSameVersionComparedWithExistingValues(V value) {
        return NetexVersionHelper.versionOf(value) >= NetexVersionHelper.latestVersionIn((Collection)this.lookup(value.getId()));
    }

    private V firstValidBestVersion(Collection<V> entities, LocalDateTime timestamp) {
        return (V)((EntityInVersionStructure)entities.stream().map(it -> new ValidOnDate<EntityInVersionStructure>((EntityInVersionStructure)it, timestamp)).filter(ValidOnDate::isValid).reduce((a, b) -> a.bestVersion(b) ? a : b).map(ValidOnDate::entity).orElse(null));
    }
}

