/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.netex.configure;

import java.io.File;
import java.util.ArrayList;
import org.opentripplanner.datastore.CompositeDataSource;
import org.opentripplanner.datastore.DataSource;
import org.opentripplanner.datastore.FileType;
import org.opentripplanner.datastore.file.ZipFileDataSource;
import org.opentripplanner.netex.NetexBundle;
import org.opentripplanner.netex.NetexModule;
import org.opentripplanner.netex.loader.NetexDataSourceHierarchy;
import org.opentripplanner.standalone.config.BuildConfig;

public class NetexConfig {
    private final BuildConfig buildParams;

    private NetexConfig(BuildConfig builderParams) {
        this.buildParams = builderParams;
    }

    public static NetexModule netexModule(BuildConfig buildParams, Iterable<DataSource> netexSources) {
        return new NetexConfig(buildParams).netexModule(netexSources);
    }

    public static NetexBundle netexBundleForTest(BuildConfig builderParams, File netexZipFile) {
        return new NetexConfig(builderParams).netexBundle(new ZipFileDataSource(netexZipFile, FileType.NETEX));
    }

    private NetexModule netexModule(Iterable<DataSource> netexSources) {
        ArrayList<NetexBundle> netexBundles = new ArrayList<NetexBundle>();
        for (DataSource it : netexSources) {
            NetexBundle netexBundle = this.netexBundle((CompositeDataSource)it);
            netexBundles.add(netexBundle);
        }
        return new NetexModule(this.buildParams.netex.netexFeedId, this.buildParams.getSubwayAccessTimeSeconds(), this.buildParams.maxInterlineDistance, this.buildParams.maxStopToShapeSnapDistance, this.buildParams.getTransitServicePeriod(), netexBundles);
    }

    private NetexBundle netexBundle(CompositeDataSource source) {
        return new NetexBundle(this.buildParams.netex.netexFeedId, source, this.hierarchy(source), this.buildParams.netex.ferryIdsNotAllowedForBicycle);
    }

    private NetexDataSourceHierarchy hierarchy(CompositeDataSource source) {
        org.opentripplanner.standalone.config.NetexConfig c = this.buildParams.netex;
        return new NetexDataSourceHierarchy(source).prepare(c.ignoreFilePattern, c.sharedFilePattern, c.sharedGroupFilePattern, c.groupFilePattern);
    }
}

