/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.netex;

import java.util.HashMap;
import java.util.List;
import org.opentripplanner.ext.flex.FlexTripsMapper;
import org.opentripplanner.graph_builder.DataImportIssueStore;
import org.opentripplanner.graph_builder.module.AddTransitModelEntitiesToGraph;
import org.opentripplanner.graph_builder.module.GtfsFeedId;
import org.opentripplanner.graph_builder.module.geometry.GeometryAndBlockProcessor;
import org.opentripplanner.graph_builder.services.GraphBuilderModule;
import org.opentripplanner.model.OtpTransitService;
import org.opentripplanner.model.calendar.CalendarServiceData;
import org.opentripplanner.model.calendar.ServiceDateInterval;
import org.opentripplanner.model.impl.OtpTransitServiceBuilder;
import org.opentripplanner.netex.NetexBundle;
import org.opentripplanner.routing.fares.FareServiceFactory;
import org.opentripplanner.routing.fares.impl.DefaultFareServiceFactory;
import org.opentripplanner.routing.graph.Graph;
import org.opentripplanner.util.OTPFeature;

public class NetexModule
implements GraphBuilderModule {
    private final double maxStopToShapeSnapDistance;
    private final int subwayAccessTime;
    private final int maxInterlineDistance;
    private final String netexFeedId;
    private final ServiceDateInterval transitPeriodLimit;
    private final List<NetexBundle> netexBundles;
    private final FareServiceFactory fareServiceFactory = new DefaultFareServiceFactory();

    public NetexModule(String netexFeedId, int subwayAccessTime, int maxInterlineDistance, double maxStopToShapeSnapDistance, ServiceDateInterval transitPeriodLimit, List<NetexBundle> netexBundles) {
        this.netexFeedId = netexFeedId;
        this.subwayAccessTime = subwayAccessTime;
        this.maxInterlineDistance = maxInterlineDistance;
        this.transitPeriodLimit = transitPeriodLimit;
        this.netexBundles = netexBundles;
        this.maxStopToShapeSnapDistance = maxStopToShapeSnapDistance;
    }

    @Override
    public void buildGraph(Graph graph, HashMap<Class<?>, Object> extra, DataImportIssueStore issueStore) {
        graph.clearTimeZone();
        CalendarServiceData calendarServiceData = graph.getCalendarDataService();
        try {
            for (NetexBundle netexBundle : this.netexBundles) {
                netexBundle.checkInputs();
                OtpTransitServiceBuilder transitBuilder = netexBundle.loadBundle(graph.deduplicator, issueStore);
                transitBuilder.limitServiceDays(this.transitPeriodLimit);
                calendarServiceData.add(transitBuilder.buildCalendarServiceData());
                if (OTPFeature.FlexRouting.isOn()) {
                    transitBuilder.getFlexTripsById().addAll(FlexTripsMapper.createFlexTrips(transitBuilder, issueStore));
                }
                OtpTransitService otpService = transitBuilder.build();
                graph.getOperators().addAll(otpService.getAllOperators());
                graph.addNoticeAssignments(otpService.getNoticeAssignments());
                GtfsFeedId feedId = new GtfsFeedId.Builder().id(this.netexFeedId).build();
                AddTransitModelEntitiesToGraph.addToGraph(feedId, otpService, this.subwayAccessTime, graph);
                new GeometryAndBlockProcessor(otpService, this.fareServiceFactory, this.maxStopToShapeSnapDistance, this.maxInterlineDistance).run(graph, issueStore);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        graph.clearCachedCalenderService();
        graph.putService(CalendarServiceData.class, calendarServiceData);
        graph.updateTransitFeedValidity(calendarServiceData, issueStore);
        graph.hasTransit = true;
        graph.calculateTransitCenter();
    }

    @Override
    public void checkInputs() {
        this.netexBundles.forEach(NetexBundle::checkInputs);
    }
}

