/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.model.transfer;

import javax.annotation.Nullable;
import org.opentripplanner.model.Route;
import org.opentripplanner.model.Trip;
import org.opentripplanner.model.transfer.RouteStationTransferPoint;
import org.opentripplanner.model.transfer.RouteStopTransferPoint;
import org.opentripplanner.model.transfer.StationTransferPoint;
import org.opentripplanner.model.transfer.StopTransferPoint;
import org.opentripplanner.model.transfer.TripTransferPoint;

public interface TransferPoint {
    public boolean appliesToAllTrips();

    public int getSpecificityRanking();

    default public boolean isTripTransferPoint() {
        return false;
    }

    default public TripTransferPoint asTripTransferPoint() {
        return (TripTransferPoint)this;
    }

    default public boolean isRouteStationTransferPoint() {
        return false;
    }

    default public RouteStationTransferPoint asRouteStationTransferPoint() {
        return (RouteStationTransferPoint)this;
    }

    default public boolean isRouteStopTransferPoint() {
        return false;
    }

    default public RouteStopTransferPoint asRouteStopTransferPoint() {
        return (RouteStopTransferPoint)this;
    }

    default public boolean isStopTransferPoint() {
        return false;
    }

    default public StopTransferPoint asStopTransferPoint() {
        return (StopTransferPoint)this;
    }

    default public boolean isStationTransferPoint() {
        return false;
    }

    default public StationTransferPoint asStationTransferPoint() {
        return (StationTransferPoint)this;
    }

    @Nullable
    public static Trip getTrip(TransferPoint point) {
        return point.isTripTransferPoint() ? point.asTripTransferPoint().getTrip() : null;
    }

    @Nullable
    public static Route getRoute(TransferPoint point) {
        if (point.isTripTransferPoint()) {
            return point.asTripTransferPoint().getTrip().getRoute();
        }
        if (point.isRouteStopTransferPoint()) {
            return point.asRouteStopTransferPoint().getRoute();
        }
        if (point.isRouteStationTransferPoint()) {
            return point.asRouteStationTransferPoint().getRoute();
        }
        return null;
    }
}

