/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.model.transfer;

import java.io.Serializable;
import java.util.Objects;
import javax.annotation.Nullable;
import org.opentripplanner.model.FeedScopedId;
import org.opentripplanner.model.base.ToStringBuilder;
import org.opentripplanner.model.transfer.TransferConstraint;
import org.opentripplanner.model.transfer.TransferPoint;
import org.opentripplanner.transit.raptor.api.transit.RaptorConstrainedTransfer;

public final class ConstrainedTransfer
implements RaptorConstrainedTransfer,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final int FROM_RANKING_COEFFICIENT = 11;
    private static final int TO_RANKING_COEFFICIENT = 10;
    private final FeedScopedId id;
    private final TransferPoint from;
    private final TransferPoint to;
    private final TransferConstraint constraint;

    public ConstrainedTransfer(@Nullable FeedScopedId id, TransferPoint from, TransferPoint to, TransferConstraint constraint) {
        this.id = id;
        this.from = from;
        this.to = to;
        this.constraint = constraint;
    }

    @Nullable
    public FeedScopedId getId() {
        return this.id;
    }

    public TransferPoint getFrom() {
        return this.from;
    }

    public TransferPoint getTo() {
        return this.to;
    }

    @Override
    public TransferConstraint getTransferConstraint() {
        return this.constraint;
    }

    public boolean noConstraints() {
        return this.constraint.isRegularTransfer();
    }

    public int getSpecificityRanking() {
        return this.from.getSpecificityRanking() * 11 + this.to.getSpecificityRanking() * 10;
    }

    public int hashCode() {
        return Objects.hash(this.from, this.to, this.constraint);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ConstrainedTransfer)) {
            return false;
        }
        ConstrainedTransfer transfer = (ConstrainedTransfer)o;
        return Objects.equals(this.constraint, transfer.constraint) && Objects.equals(this.from, transfer.from) && Objects.equals(this.to, transfer.to);
    }

    public String toString() {
        return ToStringBuilder.of(ConstrainedTransfer.class).addObj("from", this.from).addObj("to", this.to).addObj("constraint", this.constraint).toString();
    }
}

