/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.model.projectinfo;

import java.io.Serializable;
import java.util.Objects;

public class MavenProjectVersion
implements Serializable {
    private static final long serialVersionUID = 1L;
    public final String version;
    public final int major;
    public final int minor;
    public final int patch;
    public final String qualifier;

    private MavenProjectVersion(String version, int major, int minor, int patch, String qualifier) {
        this.version = version;
        this.major = major;
        this.minor = minor;
        this.patch = patch;
        this.qualifier = qualifier;
    }

    static MavenProjectVersion parse(String version) {
        String[] numFields;
        Objects.requireNonNull(version);
        int major = 0;
        int minor = 0;
        int patch = 0;
        String qualifier = "";
        int pos = version.indexOf(45);
        if (pos > 0) {
            if (pos < version.length()) {
                qualifier = version.substring(pos + 1);
            }
            numFields = MavenProjectVersion.splitInotNumFields(version.substring(0, pos));
        } else {
            numFields = MavenProjectVersion.splitInotNumFields(version);
        }
        if (numFields.length > 0) {
            major = MavenProjectVersion.parseNumField(numFields[0]);
        }
        if (numFields.length > 1) {
            minor = MavenProjectVersion.parseNumField(numFields[1]);
        }
        if (numFields.length > 2) {
            patch = MavenProjectVersion.parseNumField(numFields[2]);
        }
        return new MavenProjectVersion(version, major, minor, patch, qualifier);
    }

    public String unqualifiedVersion() {
        return String.format("%d.%d.%d", this.major, this.minor, this.patch);
    }

    public boolean sameVersion(MavenProjectVersion other) {
        return this.version.equals(other.version);
    }

    public String toString() {
        return this.version;
    }

    private static String[] splitInotNumFields(String v) {
        return v.split("\\.");
    }

    private static int parseNumField(String field) {
        try {
            return Integer.parseInt(field);
        }
        catch (NumberFormatException ignore) {
            return 0;
        }
    }
}

