/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.model.plan;

import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.opentripplanner.common.model.P2;
import org.opentripplanner.model.StreetNote;
import org.opentripplanner.model.VehicleRentalStationInfo;
import org.opentripplanner.model.WgsCoordinate;
import org.opentripplanner.model.plan.AbsoluteDirection;
import org.opentripplanner.model.plan.RelativeDirection;
import org.opentripplanner.routing.graph.Edge;
import org.opentripplanner.util.I18NString;

public class WalkStep {
    public double distance = 0.0;
    public RelativeDirection relativeDirection;
    public I18NString streetName;
    public AbsoluteDirection absoluteDirection;
    public String exit;
    public Boolean stayOn = false;
    public Boolean area = false;
    public Boolean bogusName = false;
    public WgsCoordinate startLocation;
    public List<P2<Double>> elevation;
    public final Set<StreetNote> streetNotes = new HashSet<StreetNote>();
    public double angle;
    public boolean walkingBike;
    public List<Edge> edges = Lists.newArrayList();
    public VehicleRentalStationInfo vehicleRentalOnStation;
    public VehicleRentalStationInfo vehicleRentalOffStation;

    public void setDirections(double lastAngle, double thisAngle, boolean roundabout) {
        this.relativeDirection = WalkStep.getRelativeDirection(lastAngle, thisAngle, roundabout);
        this.setAbsoluteDirection(thisAngle);
    }

    public void setAbsoluteDirection(double thisAngle) {
        int octant = (int)(8L + Math.round(thisAngle * 8.0 / (Math.PI * 2))) % 8;
        this.absoluteDirection = AbsoluteDirection.values()[octant];
    }

    public List<P2<Double>> getElevation() {
        return this.elevation;
    }

    public void addStreetNotes(Collection<StreetNote> streetNotes) {
        if (streetNotes == null) {
            return;
        }
        this.streetNotes.addAll(streetNotes);
    }

    public static RelativeDirection getRelativeDirection(double lastAngle, double thisAngle, boolean roundabout) {
        double angleDiff = thisAngle - lastAngle;
        if (angleDiff < 0.0) {
            angleDiff += Math.PI * 2;
        }
        double ccwAngleDiff = Math.PI * 2 - angleDiff;
        if (roundabout) {
            if (angleDiff > ccwAngleDiff) {
                return RelativeDirection.CIRCLE_CLOCKWISE;
            }
            return RelativeDirection.CIRCLE_COUNTERCLOCKWISE;
        }
        if (angleDiff < 0.3 || ccwAngleDiff < 0.3) {
            return RelativeDirection.CONTINUE;
        }
        if (angleDiff < 0.7) {
            return RelativeDirection.SLIGHTLY_RIGHT;
        }
        if (ccwAngleDiff < 0.7) {
            return RelativeDirection.SLIGHTLY_LEFT;
        }
        if (angleDiff < 2.0) {
            return RelativeDirection.RIGHT;
        }
        if (ccwAngleDiff < 2.0) {
            return RelativeDirection.LEFT;
        }
        if (angleDiff < Math.PI) {
            return RelativeDirection.HARD_RIGHT;
        }
        return RelativeDirection.HARD_LEFT;
    }

    public String streetNameNoParens() {
        int idx = this.streetName.toString().indexOf(40);
        if (idx <= 0) {
            return this.streetName.toString();
        }
        return this.streetName.toString().substring(0, idx - 1);
    }

    public String toString() {
        String direction = this.absoluteDirection.toString();
        if (this.relativeDirection != null) {
            direction = this.relativeDirection.toString();
        }
        return "WalkStep(" + direction + " on " + this.streetName + " for " + this.distance + ")";
    }
}

