/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.model.plan;

import java.util.Calendar;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.locationtech.jts.geom.LineString;
import org.opentripplanner.model.FeedScopedId;
import org.opentripplanner.model.StreetNote;
import org.opentripplanner.model.base.ToStringBuilder;
import org.opentripplanner.model.plan.Leg;
import org.opentripplanner.model.plan.Place;
import org.opentripplanner.model.plan.WalkStep;
import org.opentripplanner.routing.core.TraverseMode;

public class StreetLeg
implements Leg {
    private final TraverseMode mode;
    private final Calendar startTime;
    private final Calendar endTime;
    private final Double distanceMeters;
    private final Place from;
    private final Place to;
    private final LineString legGeometry;
    private final List<WalkStep> walkSteps;
    private final Set<StreetNote> streetNotes = new HashSet<StreetNote>();
    private final int generalizedCost;
    private FeedScopedId pathwayId;
    private Boolean walkingBike;
    private Boolean rentedVehicle;
    private String vehicleRentalNetwork;

    public StreetLeg(TraverseMode mode, Calendar startTime, Calendar endTime, Place from, Place to, Double distanceMeters, int generalizedCost, LineString geometry, List<WalkStep> walkSteps) {
        if (mode.isTransit()) {
            throw new IllegalArgumentException("To create a transit leg use the other classes implementing Leg.");
        }
        this.mode = mode;
        this.startTime = startTime;
        this.endTime = endTime;
        this.distanceMeters = distanceMeters;
        this.from = from;
        this.to = to;
        this.generalizedCost = generalizedCost;
        this.legGeometry = geometry;
        this.walkSteps = walkSteps;
    }

    @Override
    public boolean isTransitLeg() {
        return false;
    }

    @Override
    public boolean isWalkingLeg() {
        return this.mode.isWalking();
    }

    @Override
    public boolean isOnStreetNonTransit() {
        return true;
    }

    public void addStretNote(StreetNote streetNote) {
        this.streetNotes.add(streetNote);
    }

    public void setVehicleRentalNetwork(String network) {
        this.vehicleRentalNetwork = network;
    }

    @Override
    public TraverseMode getMode() {
        return this.mode;
    }

    @Override
    public Calendar getStartTime() {
        return this.startTime;
    }

    @Override
    public Calendar getEndTime() {
        return this.endTime;
    }

    @Override
    public Double getDistanceMeters() {
        return this.distanceMeters;
    }

    @Override
    public FeedScopedId getPathwayId() {
        return this.pathwayId;
    }

    public void setPathwayId(FeedScopedId pathwayId) {
        this.pathwayId = pathwayId;
    }

    @Override
    public Place getFrom() {
        return this.from;
    }

    @Override
    public Place getTo() {
        return this.to;
    }

    @Override
    public LineString getLegGeometry() {
        return this.legGeometry;
    }

    @Override
    public List<WalkStep> getWalkSteps() {
        return this.walkSteps;
    }

    @Override
    public Set<StreetNote> getStreetNotes() {
        return this.streetNotes;
    }

    @Override
    public Boolean getWalkingBike() {
        return this.walkingBike;
    }

    public void setWalkingBike(Boolean walkingBike) {
        this.walkingBike = walkingBike;
    }

    @Override
    public Boolean getRentedVehicle() {
        return this.rentedVehicle;
    }

    public void setRentedVehicle(Boolean rentedVehicle) {
        this.rentedVehicle = rentedVehicle;
    }

    @Override
    public String getVehicleRentalNetwork() {
        return this.vehicleRentalNetwork;
    }

    @Override
    public int getGeneralizedCost() {
        return this.generalizedCost;
    }

    public String toString() {
        return ToStringBuilder.of(StreetLeg.class).addObj("from", this.from).addObj("to", this.to).addTimeCal("startTime", this.startTime).addTimeCal("endTime", this.endTime).addEnum("mode", this.mode).addNum("distance", (Number)this.distanceMeters, "m").addNum("cost", this.generalizedCost).addObj("gtfsPathwayId", this.pathwayId).addObj("legGeometry", this.legGeometry).addCol("walkSteps", this.walkSteps).addCol("streetNotes", this.streetNotes).addBool("walkingBike", this.walkingBike).addBool("rentedVehicle", this.rentedVehicle).addStr("bikeRentalNetwork", this.vehicleRentalNetwork).toString();
    }
}

