/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.model.plan;

import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.LineString;
import org.opentripplanner.common.geometry.GeometryUtils;
import org.opentripplanner.common.geometry.SphericalDistanceLibrary;
import org.opentripplanner.model.Agency;
import org.opentripplanner.model.BookingInfo;
import org.opentripplanner.model.Operator;
import org.opentripplanner.model.PickDrop;
import org.opentripplanner.model.Route;
import org.opentripplanner.model.StopLocation;
import org.opentripplanner.model.Trip;
import org.opentripplanner.model.TripPattern;
import org.opentripplanner.model.base.ToStringBuilder;
import org.opentripplanner.model.calendar.ServiceDate;
import org.opentripplanner.model.plan.Leg;
import org.opentripplanner.model.plan.Place;
import org.opentripplanner.model.plan.StopArrival;
import org.opentripplanner.model.transfer.ConstrainedTransfer;
import org.opentripplanner.routing.alertpatch.TransitAlert;
import org.opentripplanner.routing.core.TraverseMode;
import org.opentripplanner.routing.trippattern.TripTimes;

public class ScheduledTransitLeg
implements Leg {
    protected final TripTimes tripTimes;
    protected final TripPattern tripPattern;
    private final Calendar startTime;
    private final Calendar endTime;
    private Double distanceMeters;
    private final LineString legGeometry;
    private final Set<TransitAlert> transitAlerts = new HashSet<TransitAlert>();
    private final ConstrainedTransfer transferFromPrevLeg;
    private final ConstrainedTransfer transferToNextLeg;
    protected final Integer boardStopPosInPattern;
    protected final Integer alightStopPosInPattern;
    private final int generalizedCost;
    protected final ServiceDate serviceDate;
    protected final ZoneId zoneId;

    public ScheduledTransitLeg(TripTimes tripTimes, TripPattern tripPattern, int boardStopIndexInPattern, int alightStopIndexInPattern, Calendar startTime, Calendar endTime, LocalDate serviceDate, ZoneId zoneId, ConstrainedTransfer transferFromPreviousLeg, ConstrainedTransfer transferToNextLeg, int generalizedCost) {
        this.tripTimes = tripTimes;
        this.tripPattern = tripPattern;
        this.boardStopPosInPattern = boardStopIndexInPattern;
        this.alightStopPosInPattern = alightStopIndexInPattern;
        this.startTime = startTime;
        this.endTime = endTime;
        this.serviceDate = new ServiceDate(serviceDate);
        this.zoneId = zoneId;
        this.transferFromPrevLeg = transferFromPreviousLeg;
        this.transferToNextLeg = transferToNextLeg;
        this.generalizedCost = generalizedCost;
        List<Coordinate> transitLegCoordinates = this.extractTransitLegCoordinates(tripPattern, boardStopIndexInPattern, alightStopIndexInPattern);
        this.legGeometry = GeometryUtils.makeLineString(transitLegCoordinates);
        this.distanceMeters = this.getDistanceFromCoordinates(transitLegCoordinates);
    }

    @Override
    public boolean isScheduledTransitLeg() {
        return true;
    }

    @Override
    public ScheduledTransitLeg asScheduledTransitLeg() {
        return this;
    }

    public TripTimes getTripTimes() {
        return this.tripTimes;
    }

    public TripPattern getTripPattern() {
        return this.tripPattern;
    }

    public Instant getServiceDateMidnight() {
        return this.serviceDate.toZonedDateTime(this.zoneId, 0).toInstant();
    }

    private List<Coordinate> extractTransitLegCoordinates(TripPattern tripPattern, int boardStopIndexInPattern, int alightStopIndexInPattern) {
        ArrayList<Coordinate> transitLegCoordinates = new ArrayList<Coordinate>();
        for (int i = boardStopIndexInPattern + 1; i <= alightStopIndexInPattern; ++i) {
            transitLegCoordinates.addAll(Arrays.asList(tripPattern.getHopGeometry(i - 1).getCoordinates()));
        }
        return transitLegCoordinates;
    }

    private double getDistanceFromCoordinates(List<Coordinate> coordinates) {
        double distance = 0.0;
        for (int i = 1; i < coordinates.size(); ++i) {
            distance += SphericalDistanceLibrary.distance(coordinates.get(i), coordinates.get(i - 1));
        }
        return distance;
    }

    @Override
    public boolean isTransitLeg() {
        return true;
    }

    @Override
    public Boolean isInterlinedWithPreviousLeg() {
        if (this.transferFromPrevLeg == null) {
            return false;
        }
        return this.transferFromPrevLeg.getTransferConstraint().isStaySeated();
    }

    @Override
    public void addAlert(TransitAlert alert) {
        this.transitAlerts.add(alert);
    }

    @Override
    public Agency getAgency() {
        return this.getTrip().getRoute().getAgency();
    }

    @Override
    public Operator getOperator() {
        return this.getTrip().getOperator();
    }

    @Override
    public Route getRoute() {
        return this.getTrip().getRoute();
    }

    @Override
    public Trip getTrip() {
        return this.tripTimes.getTrip();
    }

    @Override
    public TraverseMode getMode() {
        return TraverseMode.fromTransitMode(this.getTrip().getMode());
    }

    @Override
    public Calendar getStartTime() {
        return this.startTime;
    }

    @Override
    public Calendar getEndTime() {
        return this.endTime;
    }

    @Override
    public int getDepartureDelay() {
        return this.tripTimes.getDepartureDelay(this.boardStopPosInPattern);
    }

    @Override
    public int getArrivalDelay() {
        return this.tripTimes.getArrivalDelay(this.alightStopPosInPattern);
    }

    @Override
    public boolean getRealTime() {
        return !this.tripTimes.isScheduled();
    }

    @Override
    public Double getDistanceMeters() {
        return this.distanceMeters;
    }

    protected void setDistanceMeters(Double distanceMeters) {
        this.distanceMeters = distanceMeters;
    }

    @Override
    public Integer getRouteType() {
        return this.getTrip().getRoute().getGtfsType();
    }

    @Override
    public String getHeadsign() {
        return this.tripTimes.getHeadsign(this.boardStopPosInPattern);
    }

    @Override
    public ServiceDate getServiceDate() {
        return this.serviceDate;
    }

    @Override
    public Place getFrom() {
        return Place.forStop(this.tripPattern.getStop(this.boardStopPosInPattern));
    }

    @Override
    public Place getTo() {
        return Place.forStop(this.tripPattern.getStop(this.alightStopPosInPattern));
    }

    @Override
    public List<StopArrival> getIntermediateStops() {
        ArrayList<StopArrival> visits = new ArrayList<StopArrival>();
        for (int i = this.boardStopPosInPattern + 1; i < this.alightStopPosInPattern; ++i) {
            StopLocation stop = this.tripPattern.getStop(i);
            StopArrival visit = new StopArrival(Place.forStop(stop), GregorianCalendar.from(this.serviceDate.toZonedDateTime(this.zoneId, this.tripTimes.getArrivalTime(i))), GregorianCalendar.from(this.serviceDate.toZonedDateTime(this.zoneId, this.tripTimes.getDepartureTime(i))), i, this.tripTimes.getOriginalGtfsStopSequence(i));
            visits.add(visit);
        }
        return visits;
    }

    @Override
    public LineString getLegGeometry() {
        return this.legGeometry;
    }

    @Override
    public Set<TransitAlert> getTransitAlerts() {
        return this.transitAlerts;
    }

    @Override
    public PickDrop getBoardRule() {
        if (this.transferFromPrevLeg != null && this.transferFromPrevLeg.getTransferConstraint().isStaySeated()) {
            return null;
        }
        return this.tripPattern.getBoardType(this.boardStopPosInPattern);
    }

    @Override
    public PickDrop getAlightRule() {
        if (this.transferToNextLeg != null && this.transferToNextLeg.getTransferConstraint().isStaySeated()) {
            return null;
        }
        return this.tripPattern.getAlightType(this.alightStopPosInPattern);
    }

    @Override
    public BookingInfo getDropOffBookingInfo() {
        return this.tripTimes.getDropOffBookingInfo(this.alightStopPosInPattern);
    }

    @Override
    public BookingInfo getPickupBookingInfo() {
        return this.tripTimes.getPickupBookingInfo(this.boardStopPosInPattern);
    }

    @Override
    public ConstrainedTransfer getTransferFromPrevLeg() {
        return this.transferFromPrevLeg;
    }

    @Override
    public ConstrainedTransfer getTransferToNextLeg() {
        return this.transferToNextLeg;
    }

    @Override
    public Integer getBoardStopPosInPattern() {
        return this.boardStopPosInPattern;
    }

    @Override
    public Integer getAlightStopPosInPattern() {
        return this.alightStopPosInPattern;
    }

    @Override
    public Integer getBoardingGtfsStopSequence() {
        return this.tripTimes.getOriginalGtfsStopSequence(this.boardStopPosInPattern);
    }

    @Override
    public Integer getAlightGtfsStopSequence() {
        return this.tripTimes.getOriginalGtfsStopSequence(this.alightStopPosInPattern);
    }

    @Override
    public int getGeneralizedCost() {
        return this.generalizedCost;
    }

    public String toString() {
        return ToStringBuilder.of(ScheduledTransitLeg.class).addObj("from", this.getFrom()).addObj("to", this.getTo()).addTimeCal("startTime", this.startTime).addTimeCal("endTime", this.endTime).addBool("realTime", this.getRealTime()).addNum("distance", (Number)this.distanceMeters, "m").addNum("cost", this.generalizedCost).addNum("routeType", this.getRouteType()).addEntityId("agencyId", this.getAgency()).addEntityId("routeId", this.getRoute()).addEntityId("tripId", this.getTrip()).addStr("headsign", this.getHeadsign()).addObj("serviceDate", this.serviceDate).addObj("legGeometry", this.legGeometry).addCol("transitAlerts", this.transitAlerts).addEnum("boardRule", this.getBoardRule()).addEnum("alightRule", this.getAlightRule()).addObj("transferFromPrevLeg", this.transferFromPrevLeg).addObj("transferToNextLeg", this.transferToNextLeg).toString();
    }
}

