/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.model.plan;

import org.opentripplanner.model.StopLocation;
import org.opentripplanner.model.WgsCoordinate;
import org.opentripplanner.model.base.ToStringBuilder;
import org.opentripplanner.model.plan.VehicleParkingWithEntrance;
import org.opentripplanner.model.plan.VertexType;
import org.opentripplanner.routing.api.request.RoutingRequest;
import org.opentripplanner.routing.core.TraverseMode;
import org.opentripplanner.routing.graph.Vertex;
import org.opentripplanner.routing.vehicle_rental.VehicleRentalPlace;
import org.opentripplanner.routing.vertextype.VehicleParkingEntranceVertex;
import org.opentripplanner.routing.vertextype.VehicleRentalStationVertex;
import org.opentripplanner.util.I18NString;
import org.opentripplanner.util.NonLocalizedString;

public class Place {
    public final I18NString name;
    public final WgsCoordinate coordinate;
    public final VertexType vertexType;
    public final StopLocation stop;
    public final VehicleRentalPlace vehicleRentalPlace;
    public final VehicleParkingWithEntrance vehicleParkingWithEntrance;

    private Place(I18NString name, WgsCoordinate coordinate, VertexType vertexType, StopLocation stop, VehicleRentalPlace vehicleRentalPlace, VehicleParkingWithEntrance vehicleParkingWithEntrance) {
        this.name = name;
        this.coordinate = coordinate;
        this.vertexType = vertexType;
        this.stop = stop;
        this.vehicleRentalPlace = vehicleRentalPlace;
        this.vehicleParkingWithEntrance = vehicleParkingWithEntrance;
    }

    public boolean sameLocation(Place other) {
        if (this == other) {
            return true;
        }
        if (this.coordinate != null) {
            return this.coordinate.sameLocation(other.coordinate);
        }
        return this.stop != null && this.stop.equals(other.stop);
    }

    public String toStringShort() {
        StringBuilder buf = new StringBuilder(this.name.toString());
        if (this.stop != null) {
            buf.append(" (").append(this.stop.getId()).append(")");
        } else {
            buf.append(" ").append(this.coordinate.toString());
        }
        return buf.toString();
    }

    public String toString() {
        return ToStringBuilder.of(Place.class).addStr("name", this.name.toString()).addObj("stop", this.stop).addObj("coordinate", this.coordinate).addEnum("vertexType", this.vertexType).addObj("vehicleRentalPlace", this.vehicleRentalPlace).addObj("vehicleParkingEntrance", this.vehicleParkingWithEntrance).toString();
    }

    public static Place normal(Double lat, Double lon, I18NString name) {
        return new Place(name, WgsCoordinate.creatOptionalCoordinate(lat, lon), VertexType.NORMAL, null, null, null);
    }

    public static Place normal(Vertex vertex, I18NString name) {
        return new Place(name, WgsCoordinate.creatOptionalCoordinate(vertex.getLat(), vertex.getLon()), VertexType.NORMAL, null, null, null);
    }

    public static Place forStop(StopLocation stop) {
        return new Place(new NonLocalizedString(stop.getName()), stop.getCoordinate(), VertexType.TRANSIT, stop, null, null);
    }

    public static Place forFlexStop(StopLocation stop, Vertex vertex) {
        return new Place(new NonLocalizedString(stop.getName()), WgsCoordinate.creatOptionalCoordinate(vertex.getLat(), vertex.getLon()), VertexType.TRANSIT, stop, null, null);
    }

    public static Place forVehicleRentalPlace(VehicleRentalStationVertex vertex) {
        return new Place(vertex.getName(), WgsCoordinate.creatOptionalCoordinate(vertex.getLat(), vertex.getLon()), VertexType.VEHICLERENTAL, null, vertex.getStation(), null);
    }

    public static Place forVehicleParkingEntrance(VehicleParkingEntranceVertex vertex, RoutingRequest request) {
        TraverseMode traverseMode = null;
        if (request.streetSubRequestModes.getCar()) {
            traverseMode = TraverseMode.CAR;
        } else if (request.streetSubRequestModes.getBicycle()) {
            traverseMode = TraverseMode.BICYCLE;
        }
        boolean realTime = request.useVehicleParkingAvailabilityInformation && vertex.getVehicleParking().hasRealTimeDataForMode(traverseMode, request.wheelchairAccessible);
        return new Place(vertex.getName(), WgsCoordinate.creatOptionalCoordinate(vertex.getLat(), vertex.getLon()), VertexType.VEHICLEPARKING, null, null, VehicleParkingWithEntrance.builder().vehicleParking(vertex.getVehicleParking()).entrance(vertex.getParkingEntrance()).realtime(realTime).build());
    }
}

