/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.model.plan;

import java.util.Calendar;
import java.util.List;
import java.util.Set;
import java.util.TimeZone;
import org.locationtech.jts.geom.LineString;
import org.opentripplanner.model.Agency;
import org.opentripplanner.model.BookingInfo;
import org.opentripplanner.model.FeedScopedId;
import org.opentripplanner.model.Operator;
import org.opentripplanner.model.PickDrop;
import org.opentripplanner.model.Route;
import org.opentripplanner.model.StreetNote;
import org.opentripplanner.model.Trip;
import org.opentripplanner.model.calendar.ServiceDate;
import org.opentripplanner.model.plan.Place;
import org.opentripplanner.model.plan.ScheduledTransitLeg;
import org.opentripplanner.model.plan.StopArrival;
import org.opentripplanner.model.plan.WalkStep;
import org.opentripplanner.model.transfer.ConstrainedTransfer;
import org.opentripplanner.routing.alertpatch.TransitAlert;
import org.opentripplanner.routing.core.TraverseMode;

public interface Leg {
    public boolean isTransitLeg();

    default public boolean isScheduledTransitLeg() {
        return false;
    }

    default public ScheduledTransitLeg asScheduledTransitLeg() {
        throw new ClassCastException();
    }

    default public Boolean isInterlinedWithPreviousLeg() {
        return false;
    }

    default public boolean isWalkingLeg() {
        return false;
    }

    default public boolean isOnStreetNonTransit() {
        return false;
    }

    default public long getDuration() {
        return (500L + this.getEndTime().getTimeInMillis() - this.getStartTime().getTimeInMillis()) / 1000L;
    }

    default public boolean isPartiallySameTransitLeg(Leg other) {
        if (!this.isTransitLeg() || !other.isTransitLeg()) {
            throw new IllegalStateException();
        }
        if (!this.getServiceDate().equals(other.getServiceDate())) {
            return false;
        }
        if (!this.getTrip().getId().equals(other.getTrip().getId())) {
            return false;
        }
        return this.getBoardStopPosInPattern() < other.getAlightStopPosInPattern() && this.getAlightStopPosInPattern() > other.getBoardStopPosInPattern();
    }

    default public Agency getAgency() {
        return null;
    }

    default public Operator getOperator() {
        return null;
    }

    default public Route getRoute() {
        return null;
    }

    default public Trip getTrip() {
        return null;
    }

    public TraverseMode getMode();

    public Calendar getStartTime();

    public Calendar getEndTime();

    default public int getDepartureDelay() {
        return 0;
    }

    default public int getArrivalDelay() {
        return 0;
    }

    default public boolean getRealTime() {
        return false;
    }

    default public boolean isFlexibleTrip() {
        return false;
    }

    default public Boolean getNonExactFrequency() {
        return null;
    }

    default public Integer getHeadway() {
        return null;
    }

    public Double getDistanceMeters();

    default public FeedScopedId getPathwayId() {
        return null;
    }

    default public int getAgencyTimeZoneOffset() {
        TimeZone timeZone = this.getStartTime().getTimeZone();
        return timeZone.getOffset(this.getStartTime().getTimeInMillis());
    }

    default public Integer getRouteType() {
        return null;
    }

    default public String getHeadsign() {
        return null;
    }

    default public ServiceDate getServiceDate() {
        return null;
    }

    default public String getRouteBrandingUrl() {
        return null;
    }

    public Place getFrom();

    public Place getTo();

    default public List<StopArrival> getIntermediateStops() {
        return null;
    }

    public LineString getLegGeometry();

    default public List<WalkStep> getWalkSteps() {
        return List.of();
    }

    default public Set<StreetNote> getStreetNotes() {
        return null;
    }

    default public Set<TransitAlert> getTransitAlerts() {
        return null;
    }

    default public PickDrop getBoardRule() {
        return null;
    }

    default public PickDrop getAlightRule() {
        return null;
    }

    default public BookingInfo getDropOffBookingInfo() {
        return null;
    }

    default public BookingInfo getPickupBookingInfo() {
        return null;
    }

    default public ConstrainedTransfer getTransferFromPrevLeg() {
        return null;
    }

    default public ConstrainedTransfer getTransferToNextLeg() {
        return null;
    }

    default public Integer getBoardStopPosInPattern() {
        return null;
    }

    default public Integer getAlightStopPosInPattern() {
        return null;
    }

    default public Integer getBoardingGtfsStopSequence() {
        return null;
    }

    default public Integer getAlightGtfsStopSequence() {
        return null;
    }

    default public Boolean getWalkingBike() {
        return null;
    }

    default public Boolean getRentedVehicle() {
        return null;
    }

    default public String getVehicleRentalNetwork() {
        return null;
    }

    public int getGeneralizedCost();

    default public void addAlert(TransitAlert alert) {
        throw new UnsupportedOperationException();
    }
}

