/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.model.plan;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.stream.Collectors;
import org.opentripplanner.model.SystemNotice;
import org.opentripplanner.model.base.ToStringBuilder;
import org.opentripplanner.model.plan.ItinerariesCalculateLegTotals;
import org.opentripplanner.model.plan.Leg;
import org.opentripplanner.routing.core.Fare;
import org.opentripplanner.transit.raptor.util.PathStringBuilder;

public class Itinerary {
    public final int durationSeconds;
    public final int transitTimeSeconds;
    public final int nTransfers;
    public final int waitingTimeSeconds;
    public int nonTransitTimeSeconds;
    public final double nonTransitDistanceMeters;
    public Double elevationLost = 0.0;
    public Double elevationGained = 0.0;
    public int generalizedCost = -1;
    public int waitTimeOptimizedCost = -1;
    public int transferPriorityCost = -1;
    public boolean tooSloped = false;
    public boolean arrivedAtDestinationWithRentedVehicle = false;
    public final boolean walkOnly;
    public final boolean streetOnly;
    public final List<SystemNotice> systemNotices = new ArrayList<SystemNotice>();
    public Fare fare = new Fare();
    public final List<Leg> legs;

    public Itinerary(List<Leg> legs) {
        this.legs = List.copyOf(legs);
        ItinerariesCalculateLegTotals totals = new ItinerariesCalculateLegTotals(legs);
        this.durationSeconds = totals.totalDurationSeconds;
        this.nTransfers = totals.transfers();
        this.transitTimeSeconds = totals.transitTimeSeconds;
        this.nonTransitTimeSeconds = totals.nonTransitTimeSeconds;
        this.nonTransitDistanceMeters = totals.nonTransitDistanceMeters;
        this.waitingTimeSeconds = totals.waitingTimeSeconds;
        this.walkOnly = totals.walkOnly;
        this.streetOnly = totals.streetOnly;
    }

    public Calendar startTime() {
        return this.firstLeg().getStartTime();
    }

    public Calendar endTime() {
        return this.lastLeg().getEndTime();
    }

    public int departureDelay() {
        return this.firstLeg().getDepartureDelay();
    }

    public int arrivalDelay() {
        return this.lastLeg().getArrivalDelay();
    }

    public int effectiveDurationSeconds() {
        return this.transitTimeSeconds + this.nonTransitTimeSeconds;
    }

    public double distanceMeters() {
        return this.legs.stream().mapToDouble(it -> it.getDistanceMeters()).sum();
    }

    public boolean isWalkingAllTheWay() {
        return this.walkOnly;
    }

    public boolean isOnStreetAllTheWay() {
        return this.streetOnly;
    }

    public boolean hasTransit() {
        return this.transitTimeSeconds > 0;
    }

    public Leg firstLeg() {
        return this.legs.get(0);
    }

    public Leg lastLeg() {
        return this.legs.get(this.legs.size() - 1);
    }

    public Optional<Leg> firstTransitLeg() {
        return this.legs.stream().filter(Leg::isTransitLeg).findFirst();
    }

    public void flagForDeletion(SystemNotice notice) {
        this.systemNotices.add(notice);
    }

    public boolean isFlaggedForDeletion() {
        return !this.systemNotices.isEmpty();
    }

    public void timeShiftToStartAt(Calendar afterTime) {
        Calendar startTimeFirstLeg = this.firstLeg().getStartTime();
        long adjustmentMilliSeconds = afterTime.getTimeInMillis() - startTimeFirstLeg.getTimeInMillis();
        this.timeShift(adjustmentMilliSeconds);
    }

    private void timeShift(long adjustmentMilliSeconds) {
        for (Leg leg : this.legs) {
            leg.getStartTime().setTimeInMillis(leg.getStartTime().getTimeInMillis() + adjustmentMilliSeconds);
            leg.getEndTime().setTimeInMillis(leg.getEndTime().getTimeInMillis() + adjustmentMilliSeconds);
        }
    }

    public final boolean equals(Object o) {
        return super.equals(o);
    }

    public final int hashCode() {
        return super.hashCode();
    }

    public String toString() {
        return ToStringBuilder.of(Itinerary.class).addStr("from", this.firstLeg().getFrom().toStringShort()).addStr("to", this.lastLeg().getTo().toStringShort()).addTimeCal("start", this.firstLeg().getStartTime()).addTimeCal("end", this.lastLeg().getEndTime()).addNum("nTransfers", (Number)this.nTransfers, -1).addDurationSec("duration", this.durationSeconds).addNum("generalizedCost", this.generalizedCost).addDurationSec("nonTransitTime", this.nonTransitTimeSeconds).addDurationSec("transitTime", this.transitTimeSeconds).addDurationSec("waitingTime", this.waitingTimeSeconds).addNum("nonTransitDistance", (Number)this.nonTransitDistanceMeters, "m").addBool("tooSloped", this.tooSloped).addNum("elevationLost", (Number)this.elevationLost, 0.0).addNum("elevationGained", (Number)this.elevationGained, 0.0).addCol("legs", this.legs).addObj("fare", this.fare).toString();
    }

    public static String toStr(List<Itinerary> list) {
        return list.stream().map(Itinerary::toStr).collect(Collectors.joining(", "));
    }

    public String toStr() {
        PathStringBuilder buf = new PathStringBuilder(null);
        buf.stop(this.firstLeg().getFrom().name.toString());
        for (Leg leg : this.legs) {
            buf.sep();
            if (leg.isWalkingLeg()) {
                buf.walk((int)leg.getDuration());
            } else if (leg.isTransitLeg()) {
                buf.transit(leg.getMode(), leg.getTrip().logInfo(), leg.getStartTime(), leg.getEndTime());
            } else {
                buf.other(leg.getMode(), leg.getStartTime(), leg.getEndTime());
            }
            buf.sep();
            buf.stop(leg.getTo().name.toString());
        }
        buf.space().append(String.format(Locale.ROOT, "[ $%d ]", this.generalizedCost));
        return buf.toString();
    }
}

