/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.model.plan;

import java.util.List;
import org.opentripplanner.model.plan.Leg;

class ItinerariesCalculateLegTotals {
    int totalDurationSeconds = 0;
    int transitTimeSeconds = 0;
    int nTransitLegs = 0;
    int nonTransitTimeSeconds = 0;
    double nonTransitDistanceMeters = 0.0;
    int waitingTimeSeconds;
    boolean walkOnly = true;
    boolean streetOnly = true;

    public ItinerariesCalculateLegTotals(List<Leg> legs) {
        if (legs.isEmpty()) {
            return;
        }
        this.calculate(legs);
    }

    private void calculate(List<Leg> legs) {
        long startTimeMs = legs.get(0).getStartTime().getTimeInMillis();
        long endTimeMs = legs.get(legs.size() - 1).getEndTime().getTimeInMillis();
        this.totalDurationSeconds = (int)Math.round((double)(endTimeMs - startTimeMs) / 1000.0);
        for (Leg leg : legs) {
            long dt = leg.getDuration();
            if (leg.isTransitLeg()) {
                this.transitTimeSeconds = (int)((long)this.transitTimeSeconds + dt);
                ++this.nTransitLegs;
            } else if (leg.isOnStreetNonTransit()) {
                this.nonTransitTimeSeconds = (int)((long)this.nonTransitTimeSeconds + dt);
                this.nonTransitDistanceMeters += leg.getDistanceMeters().doubleValue();
            }
            if (!leg.isWalkingLeg()) {
                this.walkOnly = false;
            }
            if (leg.isOnStreetNonTransit()) continue;
            this.streetOnly = false;
        }
        this.waitingTimeSeconds = this.totalDurationSeconds - (this.transitTimeSeconds + this.nonTransitTimeSeconds);
    }

    int transfers() {
        return this.nTransitLegs == 0 ? 0 : this.nTransitLegs - 1;
    }
}

