/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.model.plan;

import java.time.LocalDate;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.List;
import org.opentripplanner.model.StopLocation;
import org.opentripplanner.model.TripPattern;
import org.opentripplanner.model.plan.Place;
import org.opentripplanner.model.plan.ScheduledTransitLeg;
import org.opentripplanner.model.plan.StopArrival;
import org.opentripplanner.model.transfer.ConstrainedTransfer;
import org.opentripplanner.routing.trippattern.TripTimes;

public class FrequencyTransitLeg
extends ScheduledTransitLeg {
    private final int frequencyHeadwayInSeconds;

    public FrequencyTransitLeg(TripTimes tripTimes, TripPattern tripPattern, int boardStopIndexInPattern, int alightStopIndexInPattern, Calendar startTime, Calendar endTime, LocalDate serviceDate, ZoneId zoneId, ConstrainedTransfer transferFromPreviousLeg, ConstrainedTransfer transferToNextLeg, int generalizedCost, int frequencyHeadwayInSeconds) {
        super(tripTimes, tripPattern, boardStopIndexInPattern, alightStopIndexInPattern, startTime, endTime, serviceDate, zoneId, transferFromPreviousLeg, transferToNextLeg, generalizedCost);
        this.frequencyHeadwayInSeconds = frequencyHeadwayInSeconds;
    }

    @Override
    public Boolean getNonExactFrequency() {
        return this.frequencyHeadwayInSeconds != 0;
    }

    @Override
    public Integer getHeadway() {
        return this.frequencyHeadwayInSeconds;
    }

    @Override
    public List<StopArrival> getIntermediateStops() {
        ArrayList<StopArrival> visits = new ArrayList<StopArrival>();
        for (int i = this.boardStopPosInPattern + 1; i < this.alightStopPosInPattern; ++i) {
            StopLocation stop = this.tripPattern.getStop(i);
            int arrivalTime = this.tripTimes.getArrivalTime(i);
            int departureTime = this.tripTimes.getDepartureTime(i) + this.frequencyHeadwayInSeconds;
            StopArrival visit = new StopArrival(Place.forStop(stop), GregorianCalendar.from(this.serviceDate.toZonedDateTime(this.zoneId, arrivalTime)), GregorianCalendar.from(this.serviceDate.toZonedDateTime(this.zoneId, departureTime)), i, this.tripTimes.getOriginalGtfsStopSequence(i));
            visits.add(visit);
        }
        return visits;
    }
}

