/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.model.modes;

import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;
import org.opentripplanner.model.TransitMode;

public class AllowedTransitMode {
    private final TransitMode mainMode;
    private final String subMode;

    public static AllowedTransitMode fromMainModeEnum(TransitMode mainMode) {
        return new AllowedTransitMode(mainMode, null);
    }

    public AllowedTransitMode(TransitMode mainMode, String subMode) {
        this.mainMode = mainMode;
        this.subMode = subMode;
    }

    public boolean allows(TransitMode transitMode, String netexSubMode) {
        return this.mainMode == transitMode && (this.subMode == null || this.subMode.equals(netexSubMode));
    }

    public TransitMode getMainMode() {
        return this.mainMode;
    }

    public boolean hasSubMode() {
        return this.subMode != null;
    }

    public static Set<AllowedTransitMode> getAllTransitModes() {
        return Arrays.stream(TransitMode.values()).map(m -> new AllowedTransitMode((TransitMode)((Object)m), null)).collect(Collectors.toSet());
    }

    public static Set<AllowedTransitMode> getAllTransitModesExceptAirplane() {
        return TransitMode.transitModesExceptAirplane().stream().map(m -> new AllowedTransitMode((TransitMode)((Object)m), null)).collect(Collectors.toSet());
    }
}

