/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.model.impl;

import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opentripplanner.ext.flex.trip.FlexTrip;
import org.opentripplanner.model.Agency;
import org.opentripplanner.model.BoardingArea;
import org.opentripplanner.model.Entrance;
import org.opentripplanner.model.FareAttribute;
import org.opentripplanner.model.FareRule;
import org.opentripplanner.model.FeedInfo;
import org.opentripplanner.model.FeedScopedId;
import org.opentripplanner.model.FlexLocationGroup;
import org.opentripplanner.model.FlexStopLocation;
import org.opentripplanner.model.GroupOfStations;
import org.opentripplanner.model.MultiModalStation;
import org.opentripplanner.model.Notice;
import org.opentripplanner.model.Operator;
import org.opentripplanner.model.OtpTransitService;
import org.opentripplanner.model.Pathway;
import org.opentripplanner.model.PathwayNode;
import org.opentripplanner.model.ShapePoint;
import org.opentripplanner.model.Station;
import org.opentripplanner.model.Stop;
import org.opentripplanner.model.StopTime;
import org.opentripplanner.model.TransitEntity;
import org.opentripplanner.model.Trip;
import org.opentripplanner.model.TripPattern;
import org.opentripplanner.model.impl.OtpTransitServiceBuilder;
import org.opentripplanner.model.transfer.ConstrainedTransfer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OtpTransitServiceImpl
implements OtpTransitService {
    private static final Logger LOG = LoggerFactory.getLogger(OtpTransitServiceImpl.class);
    private final Collection<Agency> agencies;
    private final Collection<Operator> operators;
    private final Collection<FareAttribute> fareAttributes;
    private final Collection<FareRule> fareRules;
    private final Collection<FeedInfo> feedInfos;
    private final Collection<GroupOfStations> groupsOfStations;
    private final Collection<MultiModalStation> multiModalStations;
    private final ImmutableListMultimap<TransitEntity, Notice> noticeAssignments;
    private final Collection<Pathway> pathways;
    private final Collection<FeedScopedId> serviceIds;
    private final Map<FeedScopedId, List<ShapePoint>> shapePointsByShapeId;
    private final Map<FeedScopedId, Station> stationsById;
    private final Map<FeedScopedId, Stop> stopsById;
    private final Map<FeedScopedId, Entrance> entrancesById;
    private final Map<FeedScopedId, PathwayNode> pathwayNodesById;
    private final Map<FeedScopedId, BoardingArea> boardingAreasById;
    private final Map<FeedScopedId, FlexStopLocation> locationsById;
    private final Map<FeedScopedId, FlexLocationGroup> locationGroupsById;
    private final Map<Trip, List<StopTime>> stopTimesByTrip;
    private final Collection<ConstrainedTransfer> transfers;
    private final Collection<TripPattern> tripPatterns;
    private final Collection<Trip> trips;
    private final Collection<FlexTrip> flexTrips;

    OtpTransitServiceImpl(OtpTransitServiceBuilder builder) {
        this.agencies = OtpTransitServiceImpl.immutableList(builder.getAgenciesById().values());
        this.fareAttributes = OtpTransitServiceImpl.immutableList(builder.getFareAttributes());
        this.fareRules = OtpTransitServiceImpl.immutableList(builder.getFareRules());
        this.feedInfos = OtpTransitServiceImpl.immutableList(builder.getFeedInfos());
        this.groupsOfStations = builder.getGroupsOfStationsById().values();
        this.multiModalStations = builder.getMultiModalStationsById().values();
        this.noticeAssignments = ImmutableListMultimap.copyOf(builder.getNoticeAssignments());
        this.operators = OtpTransitServiceImpl.immutableList(builder.getOperatorsById().values());
        this.pathways = OtpTransitServiceImpl.immutableList(builder.getPathways());
        this.serviceIds = OtpTransitServiceImpl.immutableList(builder.findAllServiceIds());
        this.shapePointsByShapeId = this.mapShapePoints(builder.getShapePoints());
        this.stationsById = builder.getStations().asImmutableMap();
        this.stopsById = builder.getStops().asImmutableMap();
        this.entrancesById = builder.getEntrances().asImmutableMap();
        this.pathwayNodesById = builder.getPathwayNodes().asImmutableMap();
        this.boardingAreasById = builder.getBoardingAreas().asImmutableMap();
        this.locationsById = builder.getLocations().asImmutableMap();
        this.locationGroupsById = builder.getLocationGroups().asImmutableMap();
        this.stopTimesByTrip = builder.getStopTimesSortedByTrip().asImmutableMap();
        this.transfers = OtpTransitServiceImpl.immutableList(builder.getTransfers());
        this.tripPatterns = OtpTransitServiceImpl.immutableList(builder.getTripPatterns().values());
        this.trips = OtpTransitServiceImpl.immutableList(builder.getTripsById().values());
        this.flexTrips = OtpTransitServiceImpl.immutableList(builder.getFlexTripsById().values());
        if (!builder.getFrequencies().isEmpty()) {
            LOG.error("OTP2 do not support GTFS Trip Frequencies. See https://github.com/opentripplanner/OpenTripPlanner/issues/3243.");
        }
    }

    @Override
    public Collection<Agency> getAllAgencies() {
        return this.agencies;
    }

    @Override
    public Collection<FareAttribute> getAllFareAttributes() {
        return this.fareAttributes;
    }

    @Override
    public Collection<FareRule> getAllFareRules() {
        return this.fareRules;
    }

    @Override
    public Collection<FeedInfo> getAllFeedInfos() {
        return this.feedInfos;
    }

    @Override
    public Collection<GroupOfStations> getAllGroupsOfStations() {
        return OtpTransitServiceImpl.immutableList(this.groupsOfStations);
    }

    @Override
    public Collection<MultiModalStation> getAllMultiModalStations() {
        return OtpTransitServiceImpl.immutableList(this.multiModalStations);
    }

    @Override
    public Multimap<TransitEntity, Notice> getNoticeAssignments() {
        return this.noticeAssignments;
    }

    @Override
    public Collection<Pathway> getAllPathways() {
        return this.pathways;
    }

    @Override
    public Collection<Operator> getAllOperators() {
        return this.operators;
    }

    @Override
    public Collection<FeedScopedId> getAllServiceIds() {
        return this.serviceIds;
    }

    @Override
    public List<ShapePoint> getShapePointsForShapeId(FeedScopedId shapeId) {
        return OtpTransitServiceImpl.immutableList((Collection)this.shapePointsByShapeId.get(shapeId));
    }

    @Override
    public Station getStationForId(FeedScopedId id) {
        return this.stationsById.get(id);
    }

    @Override
    public Stop getStopForId(FeedScopedId id) {
        return this.stopsById.get(id);
    }

    @Override
    public Collection<Station> getAllStations() {
        return OtpTransitServiceImpl.immutableList(this.stationsById.values());
    }

    @Override
    public Collection<Stop> getAllStops() {
        return OtpTransitServiceImpl.immutableList(this.stopsById.values());
    }

    @Override
    public Collection<Entrance> getAllEntrances() {
        return OtpTransitServiceImpl.immutableList(this.entrancesById.values());
    }

    @Override
    public Collection<PathwayNode> getAllPathwayNodes() {
        return OtpTransitServiceImpl.immutableList(this.pathwayNodesById.values());
    }

    @Override
    public Collection<BoardingArea> getAllBoardingAreas() {
        return OtpTransitServiceImpl.immutableList(this.boardingAreasById.values());
    }

    @Override
    public Collection<FlexStopLocation> getAllLocations() {
        return OtpTransitServiceImpl.immutableList(this.locationsById.values());
    }

    @Override
    public Collection<FlexLocationGroup> getAllLocationGroups() {
        return OtpTransitServiceImpl.immutableList(this.locationGroupsById.values());
    }

    @Override
    public List<StopTime> getStopTimesForTrip(Trip trip) {
        return OtpTransitServiceImpl.immutableList((Collection)this.stopTimesByTrip.get(trip));
    }

    @Override
    public Collection<ConstrainedTransfer> getAllTransfers() {
        return this.transfers;
    }

    @Override
    public Collection<TripPattern> getTripPatterns() {
        return this.tripPatterns;
    }

    @Override
    public Collection<Trip> getAllTrips() {
        return this.trips;
    }

    @Override
    public Collection<FlexTrip> getAllFlexTrips() {
        return this.flexTrips;
    }

    private Map<FeedScopedId, List<ShapePoint>> mapShapePoints(Multimap<FeedScopedId, ShapePoint> shapePoints) {
        HashMap<FeedScopedId, List<ShapePoint>> map = new HashMap<FeedScopedId, List<ShapePoint>>();
        for (Map.Entry entry : shapePoints.asMap().entrySet()) {
            map.put((FeedScopedId)entry.getKey(), new ArrayList((Collection)entry.getValue()));
        }
        for (List list : map.values()) {
            Collections.sort(list);
        }
        return map;
    }

    private static <T> List<T> immutableList(Collection<T> c) {
        ArrayList<T> list = c instanceof List ? (ArrayList<T>)c : new ArrayList<T>(c);
        return Collections.unmodifiableList(list);
    }
}

