/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.model.impl;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.opentripplanner.ext.flex.trip.FlexTrip;
import org.opentripplanner.model.Agency;
import org.opentripplanner.model.BoardingArea;
import org.opentripplanner.model.Branding;
import org.opentripplanner.model.Entrance;
import org.opentripplanner.model.FareAttribute;
import org.opentripplanner.model.FareRule;
import org.opentripplanner.model.FareZone;
import org.opentripplanner.model.FeedInfo;
import org.opentripplanner.model.FeedScopedId;
import org.opentripplanner.model.FlexLocationGroup;
import org.opentripplanner.model.FlexStopLocation;
import org.opentripplanner.model.Frequency;
import org.opentripplanner.model.GroupOfStations;
import org.opentripplanner.model.MultiModalStation;
import org.opentripplanner.model.Notice;
import org.opentripplanner.model.Operator;
import org.opentripplanner.model.OtpTransitService;
import org.opentripplanner.model.Pathway;
import org.opentripplanner.model.PathwayNode;
import org.opentripplanner.model.Route;
import org.opentripplanner.model.ShapePoint;
import org.opentripplanner.model.Station;
import org.opentripplanner.model.Stop;
import org.opentripplanner.model.StopPattern;
import org.opentripplanner.model.TransitEntity;
import org.opentripplanner.model.Trip;
import org.opentripplanner.model.TripPattern;
import org.opentripplanner.model.TripStopTimes;
import org.opentripplanner.model.calendar.CalendarServiceData;
import org.opentripplanner.model.calendar.ServiceCalendar;
import org.opentripplanner.model.calendar.ServiceCalendarDate;
import org.opentripplanner.model.calendar.ServiceDateInterval;
import org.opentripplanner.model.calendar.impl.CalendarServiceDataFactoryImpl;
import org.opentripplanner.model.impl.EntityById;
import org.opentripplanner.model.impl.OtpTransitServiceImpl;
import org.opentripplanner.model.transfer.ConstrainedTransfer;
import org.opentripplanner.model.transfer.TransferPoint;
import org.opentripplanner.util.OtpAppException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OtpTransitServiceBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(OtpTransitServiceBuilder.class);
    private final EntityById<Agency> agenciesById = new EntityById();
    private final List<ServiceCalendarDate> calendarDates = new ArrayList<ServiceCalendarDate>();
    private final List<ServiceCalendar> calendars = new ArrayList<ServiceCalendar>();
    private final List<FareAttribute> fareAttributes = new ArrayList<FareAttribute>();
    private final List<FareRule> fareRules = new ArrayList<FareRule>();
    private final List<FeedInfo> feedInfos = new ArrayList<FeedInfo>();
    private final List<Frequency> frequencies = new ArrayList<Frequency>();
    private final EntityById<GroupOfStations> groupsOfStationsById = new EntityById();
    private final EntityById<MultiModalStation> multiModalStationsById = new EntityById();
    private final Multimap<TransitEntity, Notice> noticeAssignments = ArrayListMultimap.create();
    private final EntityById<Operator> operatorsById = new EntityById();
    private final List<Pathway> pathways = new ArrayList<Pathway>();
    private final EntityById<Route> routesById = new EntityById();
    private final Multimap<FeedScopedId, ShapePoint> shapePoints = ArrayListMultimap.create();
    private final EntityById<Station> stationsById = new EntityById();
    private final EntityById<Stop> stopsById = new EntityById();
    private final EntityById<Entrance> entrancesById = new EntityById();
    private final EntityById<PathwayNode> pathwayNodesById = new EntityById();
    private final EntityById<BoardingArea> boardingAreasById = new EntityById();
    private final EntityById<FlexStopLocation> locationsById = new EntityById();
    private final EntityById<FlexLocationGroup> locationGroupsById = new EntityById();
    private final TripStopTimes stopTimesByTrip = new TripStopTimes();
    private final EntityById<FareZone> fareZonesById = new EntityById();
    private final List<ConstrainedTransfer> transfers = new ArrayList<ConstrainedTransfer>();
    private final EntityById<Trip> tripsById = new EntityById();
    private final Multimap<StopPattern, TripPattern> tripPatterns = ArrayListMultimap.create();
    private final EntityById<FlexTrip> flexTripsById = new EntityById();
    private final EntityById<Branding> brandingsById = new EntityById();

    public EntityById<Agency> getAgenciesById() {
        return this.agenciesById;
    }

    public List<ServiceCalendarDate> getCalendarDates() {
        return this.calendarDates;
    }

    public List<ServiceCalendar> getCalendars() {
        return this.calendars;
    }

    public List<FareAttribute> getFareAttributes() {
        return this.fareAttributes;
    }

    public List<FareRule> getFareRules() {
        return this.fareRules;
    }

    public List<FeedInfo> getFeedInfos() {
        return this.feedInfos;
    }

    public List<Frequency> getFrequencies() {
        return this.frequencies;
    }

    public EntityById<GroupOfStations> getGroupsOfStationsById() {
        return this.groupsOfStationsById;
    }

    public EntityById<MultiModalStation> getMultiModalStationsById() {
        return this.multiModalStationsById;
    }

    public Multimap<TransitEntity, Notice> getNoticeAssignments() {
        return this.noticeAssignments;
    }

    public EntityById<Operator> getOperatorsById() {
        return this.operatorsById;
    }

    public List<Pathway> getPathways() {
        return this.pathways;
    }

    public EntityById<Route> getRoutes() {
        return this.routesById;
    }

    public Multimap<FeedScopedId, ShapePoint> getShapePoints() {
        return this.shapePoints;
    }

    public EntityById<Station> getStations() {
        return this.stationsById;
    }

    public EntityById<Stop> getStops() {
        return this.stopsById;
    }

    public EntityById<Entrance> getEntrances() {
        return this.entrancesById;
    }

    public EntityById<PathwayNode> getPathwayNodes() {
        return this.pathwayNodesById;
    }

    public EntityById<BoardingArea> getBoardingAreas() {
        return this.boardingAreasById;
    }

    public EntityById<FlexStopLocation> getLocations() {
        return this.locationsById;
    }

    public EntityById<FlexLocationGroup> getLocationGroups() {
        return this.locationGroupsById;
    }

    public TripStopTimes getStopTimesSortedByTrip() {
        return this.stopTimesByTrip;
    }

    public EntityById<FareZone> getFareZonesById() {
        return this.fareZonesById;
    }

    public List<ConstrainedTransfer> getTransfers() {
        return this.transfers;
    }

    public EntityById<Trip> getTripsById() {
        return this.tripsById;
    }

    public Multimap<StopPattern, TripPattern> getTripPatterns() {
        return this.tripPatterns;
    }

    public EntityById<FlexTrip> getFlexTripsById() {
        return this.flexTripsById;
    }

    public EntityById<Branding> getBrandingsById() {
        return this.brandingsById;
    }

    Set<FeedScopedId> findAllServiceIds() {
        HashSet<FeedScopedId> serviceIds = new HashSet<FeedScopedId>();
        for (ServiceCalendar calendar : this.getCalendars()) {
            serviceIds.add(calendar.getServiceId());
        }
        for (ServiceCalendarDate date : this.getCalendarDates()) {
            serviceIds.add(date.getServiceId());
        }
        return serviceIds;
    }

    public CalendarServiceData buildCalendarServiceData() {
        return CalendarServiceDataFactoryImpl.createCalendarServiceData(this.getAgenciesById().values(), this.getCalendarDates(), this.getCalendars());
    }

    public OtpTransitService build() {
        return new OtpTransitServiceImpl(this);
    }

    public void limitServiceDays(ServiceDateInterval periodLimit) {
        if (periodLimit.isUnbounded()) {
            LOG.info("Limiting transit service is skipped, the period is unbounded.");
            return;
        }
        LOG.warn("Limiting transit service days to time period: {}", (Object)periodLimit);
        int orgSize = this.calendarDates.size();
        this.calendarDates.removeIf(c -> !periodLimit.include(c.getDate()));
        OtpTransitServiceBuilder.logRemove("ServiceCalendarDate", orgSize, this.calendarDates.size(), "Outside time period.");
        ArrayList<ServiceCalendar> keepCal = new ArrayList<ServiceCalendar>();
        for (ServiceCalendar calendar : this.calendars) {
            if (!calendar.getPeriod().overlap(periodLimit)) continue;
            calendar.setPeriod(calendar.getPeriod().intersection(periodLimit));
            keepCal.add(calendar);
        }
        orgSize = this.calendars.size();
        if (orgSize != keepCal.size()) {
            this.calendars.clear();
            this.calendars.addAll(keepCal);
            OtpTransitServiceBuilder.logRemove("ServiceCalendar", orgSize, this.calendars.size(), "Outside time period.");
        }
        int originalNumOfTrips = this.numberOfTrips();
        this.removeEntitiesWithInvalidReferences();
        if (originalNumOfTrips > 0 && this.numberOfTrips() == 0) {
            throw new OtpAppException("The provided transit date have no trips within the configured transit service period. See build config 'transitServiceStart' and 'transitServiceEnd': " + periodLimit);
        }
        LOG.info("Limiting transit service days to time period complete.");
    }

    private int numberOfTrips() {
        return this.tripsById.size() + this.flexTripsById.size();
    }

    private void removeEntitiesWithInvalidReferences() {
        this.removeTripsWithNoneExistingServiceIds();
        this.removeStopTimesForNoneExistingTrips();
        this.fixOrRemovePatternsWhichReferenceNoneExistingTrips();
        this.removeTransfersForNoneExistingTrips();
    }

    private void removeTripsWithNoneExistingServiceIds() {
        Set<FeedScopedId> serviceIds = this.findAllServiceIds();
        int orgSize = this.tripsById.size();
        this.tripsById.removeIf(t -> !serviceIds.contains(t.getServiceId()));
        OtpTransitServiceBuilder.logRemove("Trip", orgSize, this.tripsById.size(), "Trip service id does not exist.");
    }

    private void removeStopTimesForNoneExistingTrips() {
        int orgSize = this.stopTimesByTrip.size();
        this.stopTimesByTrip.removeIf(t -> !this.tripsById.containsKey(t.getId()));
        OtpTransitServiceBuilder.logRemove("StopTime", orgSize, this.stopTimesByTrip.size(), "StopTime trip does not exist.");
    }

    private void fixOrRemovePatternsWhichReferenceNoneExistingTrips() {
        int orgSize = this.tripPatterns.size();
        ArrayList<Map.Entry> removePatterns = new ArrayList<Map.Entry>();
        for (Map.Entry e : this.tripPatterns.entries()) {
            TripPattern ptn = (TripPattern)e.getValue();
            ptn.removeTrips(t -> !this.tripsById.containsKey(t.getId()));
            if (!ptn.scheduledTripsAsStream().findAny().isEmpty()) continue;
            removePatterns.add(e);
        }
        for (Map.Entry it : removePatterns) {
            this.tripPatterns.remove(it.getKey(), it.getValue());
        }
        OtpTransitServiceBuilder.logRemove("TripPattern", orgSize, this.tripPatterns.size(), "No trips for pattern exist.");
    }

    private void removeTransfersForNoneExistingTrips() {
        int orgSize = this.transfers.size();
        this.transfers.removeIf(this::transferTripReferencesDoNotExist);
        OtpTransitServiceBuilder.logRemove("Trip", orgSize, this.transfers.size(), "Transfer to/from trip does not exist.");
    }

    private boolean transferTripReferencesDoNotExist(ConstrainedTransfer t) {
        return this.transferPointTripReferenceDoesNotExist(t.getFrom()) || this.transferPointTripReferenceDoesNotExist(t.getTo());
    }

    private boolean transferPointTripReferenceDoesNotExist(TransferPoint point) {
        if (!point.isTripTransferPoint()) {
            return false;
        }
        Trip trip = point.asTripTransferPoint().getTrip();
        return !this.tripsById.containsKey(trip.getId());
    }

    private static void logRemove(String type, int orgSize, int newSize, String reason) {
        if (orgSize == newSize) {
            return;
        }
        LOG.info("{} of {} {}(s) removed. Reason: {}", new Object[]{orgSize - newSize, orgSize, type, reason});
    }
}

