/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.model.impl;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.opentripplanner.model.FeedScopedId;
import org.opentripplanner.model.TransitEntity;

public class EntityById<E extends TransitEntity> {
    private final Map<FeedScopedId, E> map = new HashMap<FeedScopedId, E>();

    public void add(E entity) {
        this.map.put(((TransitEntity)entity).getId(), entity);
    }

    public void addAll(Collection<E> entities) {
        entities.forEach(this::add);
    }

    public Collection<E> values() {
        return this.map.values();
    }

    public E get(FeedScopedId id) {
        return (E)((TransitEntity)this.map.get(id));
    }

    public int size() {
        return this.map.size();
    }

    public boolean containsKey(FeedScopedId id) {
        return this.map.containsKey(id);
    }

    public String toString() {
        return this.map.toString();
    }

    int removeIf(Predicate<E> test) {
        Collection newSet = this.map.values().stream().filter(Predicate.not(test)).collect(Collectors.toList());
        int size = this.map.size();
        if (newSet.size() == size) {
            return 0;
        }
        this.map.clear();
        this.addAll(newSet);
        return size - this.map.size();
    }

    Map<FeedScopedId, E> asImmutableMap() {
        return Map.copyOf(this.map);
    }
}

