/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.model.calendar.impl;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TimeZone;
import org.opentripplanner.model.FeedScopedId;
import org.opentripplanner.model.calendar.CalendarService;
import org.opentripplanner.model.calendar.CalendarServiceData;
import org.opentripplanner.model.calendar.ServiceDate;

public class CalendarServiceImpl
implements CalendarService {
    private final CalendarServiceData data;

    public CalendarServiceImpl(CalendarServiceData data) {
        this.data = data;
    }

    @Override
    public Set<FeedScopedId> getServiceIds() {
        return this.data.getServiceIds();
    }

    @Override
    public Set<ServiceDate> getServiceDatesForServiceId(FeedScopedId serviceId) {
        HashSet<ServiceDate> dates = new HashSet<ServiceDate>();
        List<ServiceDate> serviceDates = this.data.getServiceDatesForServiceId(serviceId);
        if (serviceDates != null) {
            dates.addAll(serviceDates);
        }
        return dates;
    }

    @Override
    public Set<FeedScopedId> getServiceIdsOnDate(ServiceDate date) {
        return this.data.getServiceIdsForDate(date);
    }

    @Override
    public TimeZone getTimeZoneForAgencyId(FeedScopedId agencyId) {
        return this.data.getTimeZoneForAgencyId(agencyId);
    }

    public FeedScopedId getOrCreateServiceIdForDate(ServiceDate serviceDate) {
        return this.data.getOrCreateServiceIdForDate(serviceDate);
    }
}

