/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.model.calendar.impl;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.stream.Collectors;
import org.opentripplanner.model.Agency;
import org.opentripplanner.model.FeedScopedId;
import org.opentripplanner.model.calendar.CalendarServiceData;
import org.opentripplanner.model.calendar.ServiceCalendar;
import org.opentripplanner.model.calendar.ServiceCalendarDate;
import org.opentripplanner.model.calendar.ServiceDate;
import org.opentripplanner.model.calendar.impl.MultipleCalendarsForServiceIdException;
import org.opentripplanner.model.calendar.impl.UnknownAgencyTimezoneException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CalendarServiceDataFactoryImpl {
    private static final Logger LOG = LoggerFactory.getLogger(CalendarServiceDataFactoryImpl.class);
    private final List<Agency> agencies;
    private final Map<FeedScopedId, List<ServiceCalendarDate>> calendarDatesByServiceId;
    private final Map<FeedScopedId, List<ServiceCalendar>> calendarsByServiceId;
    private final Set<FeedScopedId> serviceIds;

    public static CalendarServiceData createCalendarServiceData(Collection<Agency> agencies, Collection<ServiceCalendarDate> calendarDates, Collection<ServiceCalendar> serviceCalendars) {
        return new CalendarServiceDataFactoryImpl(agencies, calendarDates, serviceCalendars).createData();
    }

    private CalendarServiceDataFactoryImpl(Collection<Agency> agencies, Collection<ServiceCalendarDate> calendarDates, Collection<ServiceCalendar> serviceCalendars) {
        this.agencies = new ArrayList<Agency>(agencies);
        this.calendarDatesByServiceId = calendarDates.stream().collect(Collectors.groupingBy(ServiceCalendarDate::getServiceId));
        this.calendarsByServiceId = serviceCalendars.stream().collect(Collectors.groupingBy(ServiceCalendar::getServiceId));
        this.serviceIds = CalendarServiceDataFactoryImpl.merge(this.calendarDatesByServiceId.keySet(), this.calendarsByServiceId.keySet());
    }

    private CalendarServiceData createData() {
        CalendarServiceData data = new CalendarServiceData();
        this.setTimeZonesForAgencies(data);
        int index = 0;
        for (FeedScopedId serviceId : this.serviceIds) {
            LOG.debug("serviceId=" + serviceId + " (" + ++index + "/" + this.serviceIds.size() + ")");
            TimeZone serviceIdTimeZone = data.getTimeZoneForAgencyId(data.getAgencyIds().stream().filter(agency -> agency.getFeedId().equals(serviceId.getFeedId())).findAny().orElse(null));
            if (serviceIdTimeZone == null) {
                serviceIdTimeZone = TimeZone.getDefault();
            }
            Set<ServiceDate> activeDates = this.getServiceDatesForServiceId(serviceId, serviceIdTimeZone);
            ArrayList<ServiceDate> serviceDates = new ArrayList<ServiceDate>(activeDates);
            Collections.sort(serviceDates);
            data.putServiceDatesForServiceId(serviceId, serviceDates);
        }
        return data;
    }

    private Set<ServiceDate> getServiceDatesForServiceId(FeedScopedId serviceId, TimeZone serviceIdTimeZone) {
        List<ServiceCalendarDate> dates;
        HashSet<ServiceDate> activeDates = new HashSet<ServiceDate>();
        ServiceCalendar c = this.findCalendarForServiceId(serviceId);
        if (c != null) {
            this.addDatesFromCalendar(c, serviceIdTimeZone, activeDates);
        }
        if ((dates = this.calendarDatesByServiceId.get(serviceId)) != null) {
            for (ServiceCalendarDate cd : dates) {
                this.addAndRemoveDatesFromCalendarDate(cd, activeDates);
            }
        }
        return activeDates;
    }

    private ServiceCalendar findCalendarForServiceId(FeedScopedId serviceId) {
        List<ServiceCalendar> calendars = this.calendarsByServiceId.get(serviceId);
        if (calendars == null || calendars.isEmpty()) {
            return null;
        }
        if (calendars.size() == 1) {
            return calendars.get(0);
        }
        throw new MultipleCalendarsForServiceIdException(serviceId);
    }

    private void setTimeZonesForAgencies(CalendarServiceData data) {
        for (Agency agency : this.agencies) {
            TimeZone timeZone = TimeZone.getTimeZone(agency.getTimezone());
            if (timeZone.getID().equals("GMT") && !agency.getTimezone().toUpperCase().equals("GMT")) {
                throw new UnknownAgencyTimezoneException(agency.getName(), agency.getTimezone());
            }
            data.putTimeZoneForAgencyId(agency.getId(), timeZone);
        }
    }

    private void addDatesFromCalendar(ServiceCalendar calendar, TimeZone timeZone, Set<ServiceDate> activeDates) {
        Date date;
        Date startDate = CalendarServiceDataFactoryImpl.getServiceDateAsNoon(calendar.getPeriod().getStart(), timeZone);
        Date endDate = CalendarServiceDataFactoryImpl.getServiceDateAsNoon(calendar.getPeriod().getEnd(), timeZone);
        Calendar c = Calendar.getInstance(timeZone);
        c.setTime(startDate);
        while (!(date = c.getTime()).after(endDate)) {
            int day = c.get(7);
            boolean active = false;
            switch (day) {
                case 2: {
                    active = calendar.getMonday() == 1;
                    break;
                }
                case 3: {
                    active = calendar.getTuesday() == 1;
                    break;
                }
                case 4: {
                    active = calendar.getWednesday() == 1;
                    break;
                }
                case 5: {
                    active = calendar.getThursday() == 1;
                    break;
                }
                case 6: {
                    active = calendar.getFriday() == 1;
                    break;
                }
                case 7: {
                    active = calendar.getSaturday() == 1;
                    break;
                }
                case 1: {
                    boolean bl = active = calendar.getSunday() == 1;
                }
            }
            if (active) {
                this.addServiceDate(activeDates, new ServiceDate(c));
            }
            c.add(6, 1);
        }
    }

    private void addAndRemoveDatesFromCalendarDate(ServiceCalendarDate calendarDate, Set<ServiceDate> activeDates) {
        ServiceDate serviceDate = calendarDate.getDate();
        Date targetDate = calendarDate.getDate().getAsDate();
        Calendar c = Calendar.getInstance();
        c.setTime(targetDate);
        switch (calendarDate.getExceptionType()) {
            case 1: {
                this.addServiceDate(activeDates, serviceDate);
                break;
            }
            case 2: {
                activeDates.remove(serviceDate);
                break;
            }
            default: {
                LOG.warn("unknown CalendarDate exception type: " + calendarDate.getExceptionType());
            }
        }
    }

    private void addServiceDate(Set<ServiceDate> activeDates, ServiceDate serviceDate) {
        activeDates.add(serviceDate);
    }

    private static Date getServiceDateAsNoon(ServiceDate serviceDate, TimeZone timeZone) {
        Calendar c = serviceDate.getAsCalendar(timeZone);
        c.add(11, 12);
        return c.getTime();
    }

    static <T> Set<T> merge(Collection<T> set1, Collection<T> set2) {
        HashSet<T> newSet = new HashSet<T>();
        newSet.addAll(set1);
        newSet.addAll(set2);
        return newSet;
    }
}

