/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.model.calendar;

import java.util.Objects;
import javax.validation.constraints.NotNull;
import org.opentripplanner.model.calendar.ServiceDate;

public final class ServiceDateInterval {
    private static final ServiceDateInterval UNBOUNDED = new ServiceDateInterval(ServiceDate.MIN_DATE, ServiceDate.MAX_DATE);
    private final ServiceDate start;
    private final ServiceDate end;

    public ServiceDateInterval(ServiceDate start, ServiceDate end) {
        this.start = start == null ? ServiceDate.MIN_DATE : start;
        ServiceDate serviceDate = this.end = end == null ? ServiceDate.MAX_DATE : end;
        if (this.end.isBefore(this.start)) {
            throw new IllegalArgumentException("Invalid interval, the end " + end + " is before the start " + start);
        }
    }

    public static ServiceDateInterval unbounded() {
        return UNBOUNDED;
    }

    public boolean isUnbounded() {
        return this.start.equals(ServiceDate.MIN_DATE) && this.end.equals(ServiceDate.MAX_DATE);
    }

    @NotNull
    public ServiceDate getStart() {
        return this.start;
    }

    @NotNull
    public ServiceDate getEnd() {
        return this.end;
    }

    public boolean overlap(ServiceDateInterval other) {
        if (this.start.isBeforeOrEq(other.end)) {
            return this.end.isAfterOrEq(other.start);
        }
        return false;
    }

    public ServiceDateInterval intersection(ServiceDateInterval other) {
        return new ServiceDateInterval(this.start.max(other.start), this.end.min(other.end));
    }

    public boolean include(ServiceDate date) {
        return this.start.isBeforeOrEq(date) && this.end.isAfterOrEq(date);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServiceDateInterval that = (ServiceDateInterval)o;
        return this.start.equals(that.start) && this.end.equals(that.end);
    }

    public int hashCode() {
        return Objects.hash(this.start, this.end);
    }

    public String toString() {
        return "[" + this.start + ", " + this.end + "]";
    }
}

