/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.model.calendar;

import java.io.Serializable;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class ServiceDate
implements Serializable,
Comparable<ServiceDate> {
    private static final long serialVersionUID = 1L;
    private static final String MAX_TEXT = "MAX";
    private static final String MIN_TEXT = "MIN";
    private static final Pattern PATTERN = Pattern.compile("^(\\d{4})-?(\\d{2})-?(\\d{2})$");
    private static final NumberFormat YEAR_FORMAT = new DecimalFormat("0000");
    private static final NumberFormat MONTH_AND_DAY_FORMAT = new DecimalFormat("00");
    private static final TimeZone UTC_TIME_ZONE = TimeZone.getTimeZone("UTC");
    public static final ServiceDate MIN_DATE = new ServiceDate(0, 1, 1);
    public static final ServiceDate MAX_DATE = new ServiceDate(9999, 12, 31);
    private final int year;
    private final int month;
    private final int day;
    private final int sequenceNumber;

    public ServiceDate(int year, int month, int day) {
        ServiceDate.verifyIsInRange(year, 0, 9999, "year");
        ServiceDate.verifyIsInRange(month, 1, 12, "month");
        ServiceDate.verifyIsInRange(day, 1, 31, "day");
        this.year = year;
        this.month = month;
        this.day = day;
        this.sequenceNumber = 10000 * year + 100 * month + day;
    }

    @Deprecated
    public ServiceDate(Calendar calendar) {
        this(calendar.get(1), calendar.get(2) + 1, calendar.get(5));
    }

    @Deprecated
    public ServiceDate(Date date) {
        this(LocalDate.ofInstant(date.toInstant(), ZoneId.systemDefault()));
    }

    @Deprecated
    public ServiceDate() {
        this(new Date());
    }

    public ServiceDate(LocalDate date) {
        this(date.getYear(), date.getMonthValue(), date.getDayOfMonth());
    }

    public static ServiceDate parseString(String value) throws ParseException {
        Matcher matcher = PATTERN.matcher(value);
        if (!matcher.matches()) {
            throw new ParseException("error parsing date: " + value, 0);
        }
        int year = Integer.parseInt(matcher.group(1));
        int month = Integer.parseInt(matcher.group(2));
        int day = Integer.parseInt(matcher.group(3));
        return new ServiceDate(year, month, day);
    }

    public int getYear() {
        return this.year;
    }

    public int getMonth() {
        return this.month;
    }

    public int getDay() {
        return this.day;
    }

    public ZonedDateTime toZonedDateTime(ZoneId zoneId, int secondsOffset) {
        ZonedDateTime d = ZonedDateTime.of(this.year, this.month, this.day, 12, 0, 0, 0, zoneId);
        return d.minusHours(12L).plusSeconds(secondsOffset);
    }

    public ServiceDate plusSeconds(ZoneId zoneId, int seconds) {
        return new ServiceDate(this.toZonedDateTime(zoneId, seconds).toLocalDate());
    }

    @Deprecated
    public Date getAsDate() {
        return this.getAsDate(TimeZone.getDefault());
    }

    public LocalDate toLocalDate() {
        return LocalDate.of(this.year, this.month, this.day);
    }

    @Deprecated
    public Calendar getAsCalendar(TimeZone timeZone) {
        Calendar c = Calendar.getInstance();
        c.setTimeZone(timeZone);
        c.set(1, this.year);
        c.set(2, this.month - 1);
        c.set(5, this.day);
        c.set(11, 12);
        c.set(12, 0);
        c.set(13, 0);
        c.set(14, 0);
        c.add(11, -12);
        return c;
    }

    public Date getAsDate(TimeZone timeZone) {
        Calendar c = this.getAsCalendar(timeZone);
        return c.getTime();
    }

    public String asCompactString() {
        String year = YEAR_FORMAT.format(this.year);
        String month = MONTH_AND_DAY_FORMAT.format(this.month);
        String day = MONTH_AND_DAY_FORMAT.format(this.day);
        return year + month + day;
    }

    public String asISO8601() {
        return String.format("%d-%02d-%02d", this.year, this.month, this.day);
    }

    public ServiceDate next() {
        return this.shift(1);
    }

    public ServiceDate previous() {
        return this.shift(-1);
    }

    public ServiceDate shift(int numberOfDays) {
        if (numberOfDays == 0) {
            return this;
        }
        return new ServiceDate(this.toLocalDate().plusDays(numberOfDays));
    }

    @Deprecated
    public long difference(ServiceDate serviceDate) {
        return (serviceDate.getAsDate(UTC_TIME_ZONE).getTime() - this.getAsDate(UTC_TIME_ZONE).getTime()) / 86400000L;
    }

    public boolean isMinMax() {
        return this.equals(MIN_DATE) || this.equals(MAX_DATE);
    }

    public boolean isBefore(ServiceDate other) {
        return this.sequenceNumber < other.sequenceNumber;
    }

    public boolean isBeforeOrEq(ServiceDate other) {
        return this.sequenceNumber <= other.sequenceNumber;
    }

    public boolean isAfter(ServiceDate other) {
        return this.sequenceNumber > other.sequenceNumber;
    }

    public boolean isAfterOrEq(ServiceDate other) {
        return this.sequenceNumber >= other.sequenceNumber;
    }

    public ServiceDate min(ServiceDate other) {
        return this.isBefore(other) ? this : other;
    }

    public ServiceDate max(ServiceDate other) {
        return this.isAfter(other) ? this : other;
    }

    @Override
    public int compareTo(ServiceDate o) {
        return this.sequenceNumber - o.sequenceNumber;
    }

    public String toString() {
        if (MAX_DATE.equals(this)) {
            return MAX_TEXT;
        }
        if (MIN_DATE.equals(this)) {
            return MIN_TEXT;
        }
        return this.asISO8601();
    }

    public int hashCode() {
        return this.sequenceNumber;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ServiceDate other = (ServiceDate)obj;
        return this.sequenceNumber == other.sequenceNumber;
    }

    private static void verifyIsInRange(int v, int min, int max, String name) {
        if (v < min || v > max) {
            throw new IllegalArgumentException("The ServiceDate " + name + " is not valid. The value " + v + " is not in range [" + min + ", " + max + "].");
        }
    }
}

