/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.model.calendar;

import java.io.Serializable;
import java.util.Objects;
import org.opentripplanner.model.FeedScopedId;
import org.opentripplanner.model.calendar.ServiceDate;

public final class ServiceCalendarDate
implements Serializable,
Comparable<ServiceCalendarDate> {
    private static final long serialVersionUID = 1L;
    public static final int EXCEPTION_TYPE_ADD = 1;
    public static final int EXCEPTION_TYPE_REMOVE = 2;
    private final FeedScopedId serviceId;
    private final ServiceDate date;
    private final int exceptionType;

    public ServiceCalendarDate(FeedScopedId serviceId, ServiceDate date, int exceptionType) {
        this.serviceId = serviceId;
        this.date = date;
        this.exceptionType = exceptionType;
    }

    public static ServiceCalendarDate create(FeedScopedId serviceId, ServiceDate date) {
        return new ServiceCalendarDate(serviceId, date, 1);
    }

    public FeedScopedId getServiceId() {
        return this.serviceId;
    }

    public ServiceDate getDate() {
        return this.date;
    }

    public int getExceptionType() {
        return this.exceptionType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServiceCalendarDate that = (ServiceCalendarDate)o;
        return Objects.equals(this.serviceId, that.serviceId) && Objects.equals(this.date, that.date);
    }

    public int hashCode() {
        return Objects.hash(this.serviceId, this.date);
    }

    public String toString() {
        return "<CalendarDate serviceId=" + this.serviceId + " date=" + this.date + " exception=" + this.exceptionType + ">";
    }

    @Override
    public int compareTo(ServiceCalendarDate other) {
        int c = this.serviceId.compareTo(other.serviceId);
        if (c == 0) {
            c = this.date.compareTo(other.date);
        }
        return c;
    }
}

