/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.model.calendar;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.stream.Collectors;
import org.opentripplanner.model.FeedScopedId;
import org.opentripplanner.model.calendar.ServiceDate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CalendarServiceData
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String CAL_SERVICE_FEED_ID = "CSID";
    private static final Logger LOG = LoggerFactory.getLogger(CalendarServiceData.class);
    private final Map<FeedScopedId, TimeZone> timeZonesByAgencyId = new HashMap<FeedScopedId, TimeZone>();
    private final Map<FeedScopedId, List<ServiceDate>> serviceDatesByServiceId = new HashMap<FeedScopedId, List<ServiceDate>>();
    private final Map<ServiceDate, Set<FeedScopedId>> serviceIdsByDate = new HashMap<ServiceDate, Set<FeedScopedId>>();

    public TimeZone getTimeZoneForAgencyId(FeedScopedId agencyId) {
        return this.timeZonesByAgencyId.get(agencyId);
    }

    public void putTimeZoneForAgencyId(FeedScopedId agencyId, TimeZone timeZone) {
        this.timeZonesByAgencyId.put(agencyId, timeZone);
    }

    public Set<FeedScopedId> getAgencyIds() {
        return Collections.unmodifiableSet(this.timeZonesByAgencyId.keySet());
    }

    public Set<FeedScopedId> getServiceIds() {
        return Collections.unmodifiableSet(this.serviceDatesByServiceId.keySet());
    }

    public List<ServiceDate> getServiceDatesForServiceId(FeedScopedId serviceId) {
        return this.serviceDatesByServiceId.get(serviceId);
    }

    public Set<FeedScopedId> getServiceIdsForDate(ServiceDate date) {
        Set<FeedScopedId> serviceIds = this.serviceIdsByDate.get(date);
        if (serviceIds == null) {
            serviceIds = new HashSet<FeedScopedId>();
        }
        return serviceIds;
    }

    public void putServiceDatesForServiceId(FeedScopedId serviceId, List<ServiceDate> dates) {
        List<ServiceDate> serviceDates = CalendarServiceData.sortedImmutableList(dates);
        this.serviceDatesByServiceId.put(serviceId, serviceDates);
        this.addDatesToServiceIdsByDate(serviceId, serviceDates);
    }

    public FeedScopedId getOrCreateServiceIdForDate(ServiceDate serviceDate) {
        FeedScopedId serviceId = new FeedScopedId(CAL_SERVICE_FEED_ID, serviceDate.asCompactString());
        if (this.serviceDatesByServiceId.containsKey(serviceId)) {
            return serviceId;
        }
        this.serviceDatesByServiceId.put(serviceId, List.of(serviceDate));
        this.serviceIdsByDate.computeIfAbsent(serviceDate, d -> new HashSet()).add(serviceId);
        LOG.info("Adding serviceId {} to CalendarService", (Object)serviceId);
        return serviceId;
    }

    public void add(CalendarServiceData other) {
        for (FeedScopedId agencyId : other.getAgencyIds()) {
            this.putTimeZoneForAgencyId(agencyId, other.getTimeZoneForAgencyId(agencyId));
        }
        for (FeedScopedId serviceId : other.serviceDatesByServiceId.keySet()) {
            this.putServiceDatesForServiceId(serviceId, other.serviceDatesByServiceId.get(serviceId));
        }
    }

    private static <T> List<T> sortedImmutableList(Collection<T> c) {
        return Collections.unmodifiableList(c.stream().sorted().collect(Collectors.toList()));
    }

    private void addDatesToServiceIdsByDate(FeedScopedId serviceId, List<ServiceDate> serviceDates) {
        for (ServiceDate serviceDate : serviceDates) {
            Set serviceIds = this.serviceIdsByDate.computeIfAbsent(serviceDate, k -> new HashSet());
            serviceIds.add(serviceId);
        }
    }
}

