/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.model.base;

import java.text.SimpleDateFormat;
import java.time.Duration;
import java.time.Instant;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.validation.constraints.NotNull;
import org.opentripplanner.model.TransitEntity;
import org.opentripplanner.model.base.OtpNumberFormat;
import org.opentripplanner.util.time.DurationUtils;
import org.opentripplanner.util.time.TimeUtils;

public class ToStringBuilder {
    private static final int RANDOM_IGNORE_VALUE = -9371207;
    private static final String FIELD_SEPARATOR = ", ";
    private static final String FIELD_VALUE_SEP = ": ";
    private static final String NULL_VALUE = "null";
    private final StringBuilder sb = new StringBuilder();
    private final OtpNumberFormat numFormat = new OtpNumberFormat();
    private SimpleDateFormat calendarTimeFormat;
    boolean first = true;

    private ToStringBuilder(String name) {
        this.sb.append(name).append("{");
    }

    public static ToStringBuilder of(Class<?> clazz) {
        return new ToStringBuilder(clazz.getSimpleName());
    }

    public static ToStringBuilder of() {
        return new ToStringBuilder("");
    }

    public ToStringBuilder addNum(String name, Number num) {
        return this.addIfNotNull(name, num, this.numFormat::formatNumber);
    }

    public ToStringBuilder addNum(String name, Number value, Number ignoreValue) {
        return this.addIfNotIgnored(name, value, ignoreValue, this.numFormat::formatNumber);
    }

    public ToStringBuilder addNum(String name, Number num, String unit) {
        return this.addIfNotNull(name, num, n -> this.numFormat.formatNumber((Number)n, unit));
    }

    public ToStringBuilder addBool(String name, Boolean value) {
        return this.addIfNotNull(name, value);
    }

    public ToStringBuilder addBoolIfTrue(String name, Boolean value) {
        if (Boolean.TRUE.equals(value)) {
            this.addLabel(name);
        }
        return this;
    }

    public ToStringBuilder addStr(String name, String value) {
        return this.addIfNotNull(name, value, v -> "'" + v + "'");
    }

    public ToStringBuilder addEnum(String name, Enum<?> value) {
        return this.addEnum(name, value, null);
    }

    public ToStringBuilder addEnum(String name, Enum<?> value, Enum<?> ignoreValue) {
        return this.addIfNotIgnored(name, value, ignoreValue, Enum::name);
    }

    public ToStringBuilder addObj(String name, Object obj) {
        return this.addIfNotNull(name, obj);
    }

    public ToStringBuilder addEntityId(String name, TransitEntity entity) {
        return this.addIfNotNull(name, entity, e -> e.getId().toString());
    }

    public ToStringBuilder addInts(String name, int[] intArray) {
        return this.addIfNotNull(name, intArray, Arrays::toString);
    }

    public ToStringBuilder addDoubles(String name, double[] value, double ignoreValue) {
        if (value == null) {
            return this.addIt(name, NULL_VALUE);
        }
        if (Arrays.stream(value).allMatch(it -> Objects.equals(it, ignoreValue))) {
            return this;
        }
        return this.addIt(name, Arrays.toString(value));
    }

    public ToStringBuilder addCol(String name, Collection<?> c) {
        return this.addIfNotNull(name, c);
    }

    public ToStringBuilder addColSize(String name, Collection<?> c) {
        return this.addIfNotNull(name, c, x -> String.format("%d items", x.size()));
    }

    public ToStringBuilder addCollection(String name, Collection<?> c, int maxLimit) {
        if (c == null) {
            return this;
        }
        if (c.size() > maxLimit + 1) {
            String value = c.stream().limit(maxLimit).map(Object::toString).collect(Collectors.joining(FIELD_SEPARATOR));
            return this.addIt(name + "(" + maxLimit + "/" + c.size() + ")", "[" + value + ", ..]");
        }
        return this.addIfNotNull(name, c);
    }

    public ToStringBuilder addIntArraySize(String name, int[] array, int notSet) {
        if (array == null) {
            return this;
        }
        return this.addIt(name, Arrays.stream(array).filter(t -> t != notSet).count() + "/" + array.length);
    }

    public ToStringBuilder addBitSetSize(String name, BitSet bitSet) {
        if (bitSet == null) {
            return this;
        }
        return this.addIt(name, bitSet.cardinality() + "/" + bitSet.length());
    }

    public ToStringBuilder addCoordinate(String name, Number num) {
        return this.addIfNotNull(name, num, this.numFormat::formatCoordinate);
    }

    public ToStringBuilder addTimeCal(String name, Calendar time) {
        return this.addIfNotNull(name, time, t -> this.formatTime(t.getTime()));
    }

    public ToStringBuilder addServiceTime(String name, int timeSecondsPastMidnight, int ignoreValue) {
        return this.addIfNotIgnored(name, timeSecondsPastMidnight, ignoreValue, TimeUtils::timeToStrCompact);
    }

    public ToStringBuilder addServiceTime(String name, int timeSecondsPastMidnight) {
        return this.addIfNotIgnored(name, timeSecondsPastMidnight, -9371207, TimeUtils::timeToStrCompact);
    }

    public ToStringBuilder addServiceTimeSchedule(String name, int[] value) {
        return this.addIfNotNull(name, value, a -> Arrays.stream(a).mapToObj(TimeUtils::timeToStrCompact).collect(Collectors.joining(" ", "[", "]")));
    }

    public ToStringBuilder addTime(String name, Instant time) {
        return this.addIfNotNull(name, time, Instant::toString);
    }

    public ToStringBuilder addDurationSec(String name, Integer durationSeconds) {
        return this.addDurationSec(name, durationSeconds, null);
    }

    public ToStringBuilder addDurationSec(String name, Integer durationSeconds, Integer ignoreValue) {
        return this.addIfNotIgnored(name, durationSeconds, ignoreValue, DurationUtils::durationToStr);
    }

    public ToStringBuilder addDuration(String name, Duration duration) {
        return this.addIfNotIgnored(name, duration, null, d -> DurationUtils.durationToStr((int)d.toSeconds()));
    }

    public String toString() {
        return this.sb.append("}").toString();
    }

    private <T> ToStringBuilder addIfNotNull(String name, T value) {
        return this.addIfNotIgnored(name, value, null, Object::toString);
    }

    private <T> ToStringBuilder addIfNotNull(String name, T value, Function<T, String> vToString) {
        return this.addIfNotIgnored(name, value, null, vToString);
    }

    private <T> ToStringBuilder addIfNotIgnored(String name, T value, T ignoreValue, Function<T, String> mapToString) {
        if (Objects.equals(ignoreValue, value)) {
            return this;
        }
        if (value == null) {
            return this.addIt(name, NULL_VALUE);
        }
        return this.addIt(name, mapToString.apply(value));
    }

    private ToStringBuilder addIt(String name, @NotNull String value) {
        this.addLabel(name);
        this.addValue(value);
        return this;
    }

    private void addLabel(String name) {
        if (this.first) {
            this.first = false;
        } else {
            this.sb.append(FIELD_SEPARATOR);
        }
        this.sb.append(name);
    }

    private void addValue(@NotNull String value) {
        this.sb.append(FIELD_VALUE_SEP);
        this.sb.append(value);
    }

    private String formatTime(Date time) {
        if (this.calendarTimeFormat == null) {
            this.calendarTimeFormat = new SimpleDateFormat("HH:mm:ss");
        }
        return this.calendarTimeFormat.format(time.getTime());
    }
}

