/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.model.base;

import java.math.BigInteger;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;

public class OtpNumberFormat {
    private static final String NULL_VALUE = "null";
    private static final DecimalFormatSymbols DECIMAL_SYMBOLS = DecimalFormatSymbols.getInstance(Locale.US);
    private DecimalFormat integerFormat;
    private DecimalFormat decimalFormat;
    private DecimalFormat coordinateFormat;

    String formatCoordinate(Number value) {
        if (this.coordinateFormat == null) {
            this.coordinateFormat = new DecimalFormat("#0.0####", DECIMAL_SYMBOLS);
        }
        return value == null ? NULL_VALUE : this.coordinateFormat.format(value);
    }

    String formatNumber(Number value, String unit) {
        return this.formatNumber(value) + unit;
    }

    String formatNumber(Number value) {
        if (value == null) {
            return NULL_VALUE;
        }
        if (value instanceof Integer || value instanceof Long || value instanceof BigInteger) {
            if (this.integerFormat == null) {
                this.integerFormat = new DecimalFormat("#,##0", DECIMAL_SYMBOLS);
            }
            return this.integerFormat.format(value);
        }
        if (this.decimalFormat == null) {
            this.decimalFormat = new DecimalFormat("#,##0.0##", DECIMAL_SYMBOLS);
        }
        return this.decimalFormat.format(value);
    }

    public static String formatCost(int cost) {
        if (Math.abs(cost) >= 1000000 || cost % 100 == 0) {
            return "$" + cost / 100;
        }
        return String.format(Locale.ROOT, "$%.2f", (double)cost / 100.0);
    }

    public static String formatCost(int cost, String unit) {
        return OtpNumberFormat.formatCost(cost) + unit;
    }
}

