/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.model;

import java.io.Serializable;
import org.locationtech.jts.geom.Coordinate;
import org.opentripplanner.model.base.ValueObjectToStringBuilder;

public final class WgsCoordinate
implements Serializable {
    private static final String WHY_COORDINATE_DO_NOT_HAVE_HASH_EQUALS = "Use the 'sameLocation(..)' method to compare coordinates. See JavaDoc on 'equals(..)'";
    private static final double EPSILON = 1.0E-7;
    private final double latitude;
    private final double longitude;

    public WgsCoordinate(double latitude, double longitude) {
        this.latitude = latitude;
        this.longitude = longitude;
    }

    public static WgsCoordinate creatOptionalCoordinate(Double latitude, Double longitude) {
        if (latitude == null && longitude == null) {
            return null;
        }
        if (latitude != null && longitude != null) {
            return new WgsCoordinate(latitude, longitude);
        }
        throw new IllegalArgumentException("Both 'latitude' and 'longitude' must have a value or both must be 'null'.");
    }

    public double latitude() {
        return this.latitude;
    }

    public double longitude() {
        return this.longitude;
    }

    public Coordinate asJtsCoordinate() {
        return new Coordinate(this.longitude, this.latitude);
    }

    public boolean sameLocation(WgsCoordinate other) {
        if (this == other) {
            return true;
        }
        return WgsCoordinate.isCloseTo(this.latitude, other.latitude) && WgsCoordinate.isCloseTo(this.longitude, other.longitude);
    }

    public boolean equals(Object obj) {
        throw new UnsupportedOperationException(WHY_COORDINATE_DO_NOT_HAVE_HASH_EQUALS);
    }

    public int hashCode() {
        throw new UnsupportedOperationException(WHY_COORDINATE_DO_NOT_HAVE_HASH_EQUALS);
    }

    public String toString() {
        return ValueObjectToStringBuilder.of().addCoordinate(this.latitude(), this.longitude()).toString();
    }

    private static boolean isCloseTo(double a, double b) {
        double delta = Math.abs(a - b);
        return delta < 1.0E-7;
    }
}

