/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.model;

import java.time.Instant;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.opentripplanner.model.BookingInfo;
import org.opentripplanner.model.FeedScopedId;
import org.opentripplanner.model.PickDrop;
import org.opentripplanner.model.StopTimeKey;
import org.opentripplanner.model.Timetable;
import org.opentripplanner.model.Trip;
import org.opentripplanner.model.TripPattern;
import org.opentripplanner.routing.core.ServiceDay;
import org.opentripplanner.routing.trippattern.RealTimeState;
import org.opentripplanner.routing.trippattern.TripTimes;

public class TripTimeOnDate {
    public static final int UNDEFINED = -1;
    private final TripTimes tripTimes;
    private final int stopIndex;
    private final TripPattern tripPattern;
    private final Integer midnight;

    public TripTimeOnDate(TripTimes tripTimes, int stopIndex, TripPattern tripPattern, ServiceDay serviceDay) {
        this.tripTimes = tripTimes;
        this.stopIndex = stopIndex;
        this.tripPattern = tripPattern;
        this.midnight = serviceDay != null ? serviceDay.secondsSinceMidnight(0L) : -1;
    }

    public TripTimeOnDate(TripTimes tripTimes, int stopIndex, TripPattern tripPattern, Instant midnight) {
        this.tripTimes = tripTimes;
        this.stopIndex = stopIndex;
        this.tripPattern = tripPattern;
        this.midnight = (int)midnight.getEpochSecond();
    }

    public static List<TripTimeOnDate> fromTripTimes(Timetable table, Trip trip) {
        TripTimes times = table.getTripTimes(table.getTripIndex(trip.getId()));
        ArrayList<TripTimeOnDate> out = new ArrayList<TripTimeOnDate>();
        for (int i = 0; i < times.getNumStops(); ++i) {
            out.add(new TripTimeOnDate(times, i, table.getPattern(), (ServiceDay)null));
        }
        return out;
    }

    public static List<TripTimeOnDate> fromTripTimes(Timetable table, Trip trip, ServiceDay serviceDay) {
        TripTimes times = table.getTripTimes(table.getTripIndex(trip.getId()));
        ArrayList<TripTimeOnDate> out = new ArrayList<TripTimeOnDate>();
        for (int i = 0; i < times.getNumStops(); ++i) {
            out.add(new TripTimeOnDate(times, i, table.getPattern(), serviceDay));
        }
        return out;
    }

    public static Comparator<TripTimeOnDate> compareByDeparture() {
        return Comparator.comparing(t -> t.getServiceDay() + (long)t.getRealtimeDeparture());
    }

    public FeedScopedId getStopId() {
        return this.tripPattern.getStop(this.stopIndex).getId();
    }

    public int getStopIndex() {
        return this.stopIndex;
    }

    public int getStopCount() {
        return this.tripTimes.getNumStops();
    }

    public int getScheduledArrival() {
        return this.tripTimes.getScheduledArrivalTime(this.stopIndex);
    }

    public int getScheduledDeparture() {
        return this.tripTimes.getScheduledDepartureTime(this.stopIndex);
    }

    public int getRealtimeArrival() {
        return this.isRealtime() && this.isCancelledStop() ? this.tripTimes.getScheduledArrivalTime(this.stopIndex) : this.tripTimes.getArrivalTime(this.stopIndex);
    }

    public int getRealtimeDeparture() {
        return this.isRealtime() && this.isCancelledStop() ? this.tripTimes.getScheduledDepartureTime(this.stopIndex) : this.tripTimes.getDepartureTime(this.stopIndex);
    }

    public int getActualArrival() {
        return this.tripTimes.isRecordedStop(this.stopIndex) ? this.tripTimes.getArrivalTime(this.stopIndex) : -1;
    }

    public int getActualDeparture() {
        return this.tripTimes.isRecordedStop(this.stopIndex) ? this.tripTimes.getDepartureTime(this.stopIndex) : -1;
    }

    public int getArrivalDelay() {
        return this.tripTimes.getArrivalDelay(this.stopIndex);
    }

    public int getDepartureDelay() {
        return this.tripTimes.getDepartureDelay(this.stopIndex);
    }

    public boolean isTimepoint() {
        return this.tripTimes.isTimepoint(this.stopIndex);
    }

    public boolean isRealtime() {
        return !this.tripTimes.isScheduled();
    }

    public boolean isCancelledStop() {
        return this.tripTimes.isCancelledStop(this.stopIndex) || this.tripPattern.isBoardAndAlightAt(this.stopIndex, PickDrop.CANCELLED);
    }

    public boolean isCanceledEffectively() {
        return this.isCancelledStop() || this.tripTimes.isCanceled() || this.tripTimes.getTrip().getTripAlteration().isCanceledOrReplaced();
    }

    public RealTimeState getRealtimeState() {
        return this.tripTimes.getRealTimeState();
    }

    public long getServiceDay() {
        return this.midnight.intValue();
    }

    public Trip getTrip() {
        return this.tripTimes.getTrip();
    }

    public String getBlockId() {
        return this.tripTimes.getTrip().getBlockId();
    }

    public String getHeadsign() {
        return this.tripTimes.getHeadsign(this.stopIndex);
    }

    public List<String> getHeadsignVias() {
        return this.tripTimes.getVia(this.stopIndex);
    }

    public PickDrop getPickupType() {
        return this.tripTimes.isCanceled() || this.tripTimes.isCancelledStop(this.stopIndex) ? PickDrop.CANCELLED : this.tripPattern.getBoardType(this.stopIndex);
    }

    public PickDrop getDropoffType() {
        return this.tripTimes.isCanceled() || this.tripTimes.isCancelledStop(this.stopIndex) ? PickDrop.CANCELLED : this.tripPattern.getAlightType(this.stopIndex);
    }

    public StopTimeKey getStopTimeKey() {
        return new StopTimeKey(this.tripTimes.getTrip().getId(), this.stopIndex);
    }

    public BookingInfo getPickupBookingInfo() {
        return this.tripTimes.getPickupBookingInfo(this.stopIndex);
    }

    public BookingInfo getDropOffBookingInfo() {
        return this.tripTimes.getDropOffBookingInfo(this.stopIndex);
    }
}

