/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.opentripplanner.model.StopTime;
import org.opentripplanner.model.Trip;

public class TripStopTimes {
    private static final List<StopTime> EMPTY_LIST = Collections.emptyList();
    private final Map<Trip, List<StopTime>> map = new HashMap<Trip, List<StopTime>>();

    public List<StopTime> get(Trip key) {
        List<StopTime> list = this.map.get(key);
        return list == null ? EMPTY_LIST : Collections.unmodifiableList(list);
    }

    public void addAll(Collection<StopTime> values) {
        HashSet<Trip> keysUpdated = new HashSet<Trip>();
        for (StopTime value : values) {
            Trip key = value.getTrip();
            keysUpdated.add(key);
            this.map.computeIfAbsent(key, trip -> new ArrayList()).add(value);
        }
        for (Trip key : keysUpdated) {
            Collections.sort(this.map.get(key));
        }
    }

    public void replace(Trip key, Collection<StopTime> list) {
        this.map.replace(key, TripStopTimes.sort(list));
    }

    public void put(Trip key, Collection<StopTime> list) {
        this.map.put(key, TripStopTimes.sort(list));
    }

    public void removeIf(Predicate<Trip> test) {
        List removeKeys = this.map.keySet().stream().filter(test).collect(Collectors.toList());
        for (Trip removeKey : removeKeys) {
            this.map.remove(removeKey);
        }
    }

    public Map<Trip, List<StopTime>> asImmutableMap() {
        return Map.copyOf(this.map);
    }

    public int size() {
        return this.map.size();
    }

    public Iterable<Trip> keys() {
        return this.map.keySet();
    }

    private static List<StopTime> sort(Collection<StopTime> list) {
        ArrayList<StopTime> values = new ArrayList<StopTime>(list);
        Collections.sort(values);
        return values;
    }
}

