/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.model;

import com.beust.jcommander.internal.Maps;
import com.beust.jcommander.internal.Sets;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import com.google.common.io.BaseEncoding;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.LineString;
import org.opentripplanner.common.geometry.CompactLineString;
import org.opentripplanner.common.geometry.GeometryUtils;
import org.opentripplanner.graph_builder.DataImportIssueStore;
import org.opentripplanner.graph_builder.issues.NonUniqueRouteName;
import org.opentripplanner.model.Direction;
import org.opentripplanner.model.FeedScopedId;
import org.opentripplanner.model.PickDrop;
import org.opentripplanner.model.Route;
import org.opentripplanner.model.Station;
import org.opentripplanner.model.StopLocation;
import org.opentripplanner.model.StopPattern;
import org.opentripplanner.model.Timetable;
import org.opentripplanner.model.TransitEntity;
import org.opentripplanner.model.TransitMode;
import org.opentripplanner.model.Trip;
import org.opentripplanner.model.WheelChairBoarding;
import org.opentripplanner.routing.trippattern.FrequencyEntry;
import org.opentripplanner.routing.trippattern.TripTimes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TripPattern
extends TransitEntity
implements Cloneable,
Serializable {
    private static final Logger LOG = LoggerFactory.getLogger(TripPattern.class);
    private static final long serialVersionUID = 1L;
    private String name;
    private final Route route;
    private final StopPattern stopPattern;
    private final Timetable scheduledTimetable = new Timetable(this);
    private byte[][] hopGeometries = null;
    private TripPattern originalTripPattern = null;
    private boolean createdByRealtimeUpdater = false;
    private BitSet services;

    public TripPattern(FeedScopedId id, Route route, StopPattern stopPattern) {
        super(id);
        this.route = route;
        this.stopPattern = stopPattern;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Route getRoute() {
        return this.route;
    }

    public TransitMode getMode() {
        return this.route.getMode();
    }

    public final String getNetexSubmode() {
        return this.route.getNetexSubmode();
    }

    public LineString getHopGeometry(int stopPosInPattern) {
        if (this.hopGeometries != null) {
            return CompactLineString.uncompactLineString(this.hopGeometries[stopPosInPattern], false);
        }
        return GeometryUtils.getGeometryFactory().createLineString(new Coordinate[]{TripPattern.coordinate(this.stopPattern.getStop(stopPosInPattern)), TripPattern.coordinate(this.stopPattern.getStop(stopPosInPattern + 1))});
    }

    public void setHopGeometries(LineString[] hopGeometries) {
        this.hopGeometries = new byte[hopGeometries.length][];
        for (int i = 0; i < hopGeometries.length; ++i) {
            this.setHopGeometry(i, hopGeometries[i]);
        }
    }

    public void setHopGeometry(int i, LineString hopGeometry) {
        this.hopGeometries[i] = CompactLineString.compactLineString(hopGeometry, false);
    }

    public void setHopGeometriesFromPattern(TripPattern other) {
        this.hopGeometries = new byte[this.numberOfStops() - 1][];
        int sizeOfShortestPattern = Math.min(this.numberOfStops(), other.numberOfStops());
        for (int i = 0; i < sizeOfShortestPattern - 1; ++i) {
            if (other.getHopGeometry(i) != null && other.getStop(i).equals(this.getStop(i)) && other.getStop(i + 1).equals(this.getStop(i + 1))) {
                this.setHopGeometry(i, other.getHopGeometry(i));
                continue;
            }
            this.setHopGeometry(i, GeometryUtils.getGeometryFactory().createLineString(new Coordinate[]{TripPattern.coordinate(this.stopPattern.getStop(i)), TripPattern.coordinate(this.stopPattern.getStop(i + 1))}));
        }
    }

    public LineString getGeometry() {
        if (this.hopGeometries == null || this.hopGeometries.length == 0) {
            return null;
        }
        ArrayList<LineString> lineStrings = new ArrayList<LineString>();
        for (int i = 0; i < this.hopGeometries.length; ++i) {
            lineStrings.add(this.getHopGeometry(i));
        }
        return GeometryUtils.concatenateLineStrings(lineStrings);
    }

    public int numHopGeometries() {
        return this.hopGeometries.length;
    }

    public int numberOfStops() {
        return this.stopPattern.getSize();
    }

    public StopLocation getStop(int stopPosInPattern) {
        return this.stopPattern.getStop(stopPosInPattern);
    }

    public StopLocation firstStop() {
        return this.getStop(0);
    }

    public StopLocation lastStop() {
        return this.getStop(this.stopPattern.getSize() - 1);
    }

    public List<StopLocation> getStops() {
        return this.stopPattern.getStops();
    }

    public int findStopPosition(StopLocation stop) {
        return this.stopPattern.findStopPosition(stop);
    }

    public int findBoardingStopPositionInPattern(Station station) {
        return this.stopPattern.findBoardingPosition(station);
    }

    public int findAlightStopPositionInPattern(Station station) {
        return this.stopPattern.findAlightPosition(station);
    }

    public int findBoardingStopPositionInPattern(StopLocation stop) {
        return this.stopPattern.findBoardingPosition(stop);
    }

    public int findAlightStopPositionInPattern(StopLocation stop) {
        return this.stopPattern.findAlightPosition(stop);
    }

    public boolean canAlight(int stopIndex) {
        return this.stopPattern.canAlight(stopIndex);
    }

    public boolean canBoard(int stopIndex) {
        return this.stopPattern.canBoard(stopIndex);
    }

    public boolean canBoard(StopLocation stop) {
        return this.stopPattern.canBoard(stop);
    }

    public boolean wheelchairAccessible(int stopIndex) {
        return this.stopPattern.getStop(stopIndex).getWheelchairBoarding() == WheelChairBoarding.POSSIBLE;
    }

    public PickDrop getAlightType(int stopIndex) {
        return this.stopPattern.getDropoff(stopIndex);
    }

    public PickDrop getBoardType(int stopIndex) {
        return this.stopPattern.getPickup(stopIndex);
    }

    public boolean isBoardAndAlightAt(int stopIndex, PickDrop value) {
        return this.getBoardType(stopIndex).is(value) && this.getAlightType(stopIndex).is(value);
    }

    public boolean stopPatternIsEqual(TripPattern other) {
        return this.stopPattern.equals(other.stopPattern);
    }

    public Trip getTrip(int tripIndex) {
        return this.scheduledTimetable.getTripTimes(tripIndex).getTrip();
    }

    public void add(TripTimes tt) {
        this.scheduledTimetable.addTripTimes(tt);
        if (this.route != tt.getTrip().getRoute()) {
            LOG.warn("The trip {} is on route {} but its stop pattern is on route {}.", new Object[]{tt.getTrip(), tt.getTrip().getRoute(), this.route});
        }
    }

    public void add(FrequencyEntry freq) {
        this.scheduledTimetable.addFrequencyEntry(freq);
        if (this.getRoute() != freq.tripTimes.getTrip().getRoute()) {
            LOG.warn("The trip {} is on a different route than its stop pattern, which is on {}.", (Object)freq.tripTimes.getTrip(), (Object)this.route);
        }
    }

    public void removeTrips(Predicate<Trip> removeTrip) {
        this.scheduledTimetable.getTripTimes().removeIf(tt -> removeTrip.test(tt.getTrip()));
    }

    public void setOriginalTripPattern(TripPattern originalTripPattern) {
        this.originalTripPattern = originalTripPattern;
    }

    public Direction getDirection() {
        return this.scheduledTimetable.getDirection();
    }

    public Stream<Trip> scheduledTripsAsStream() {
        return this.scheduledTimetable.getTripTimes().stream().map(TripTimes::getTrip).distinct();
    }

    public Timetable getScheduledTimetable() {
        return this.scheduledTimetable;
    }

    public boolean isCreatedByRealtimeUpdater() {
        return this.createdByRealtimeUpdater;
    }

    public void setCreatedByRealtimeUpdater() {
        this.createdByRealtimeUpdater = true;
    }

    private static String stopNameAndId(StopLocation stop) {
        return stop.getName() + " (" + stop.getId().toString() + ")";
    }

    public static void generateUniqueNames(Collection<TripPattern> tableTripPatterns, DataImportIssueStore issueStore) {
        Collection routeTripPatterns;
        LOG.info("Generating unique names for stop patterns on each route.");
        Set usedRouteNames = Sets.newHashSet();
        Map uniqueRouteNames = Maps.newHashMap();
        ArrayListMultimap patternsByRoute = ArrayListMultimap.create();
        for (TripPattern ttp : tableTripPatterns) {
            patternsByRoute.put((Object)ttp.route, (Object)ttp);
        }
        for (Route route : patternsByRoute.keySet()) {
            Object routeName = route.getName();
            if (usedRouteNames.contains(routeName)) {
                String generatedRouteName;
                int i = 2;
                while (usedRouteNames.contains(generatedRouteName = (String)routeName + " " + i++)) {
                }
                issueStore.add(new NonUniqueRouteName(generatedRouteName));
                routeName = generatedRouteName;
            }
            usedRouteNames.add(routeName);
            uniqueRouteNames.put(route, routeName);
        }
        for (Route route : patternsByRoute.keySet()) {
            StopLocation end;
            routeTripPatterns = patternsByRoute.get((Object)route);
            String routeName = (String)uniqueRouteNames.get(route);
            if (routeTripPatterns.size() == 1) {
                ((TripPattern)routeTripPatterns.iterator().next()).setName(routeName);
                continue;
            }
            ArrayListMultimap signs = ArrayListMultimap.create();
            ArrayListMultimap starts = ArrayListMultimap.create();
            ArrayListMultimap ends = ArrayListMultimap.create();
            ArrayListMultimap vias = ArrayListMultimap.create();
            for (TripPattern pattern : routeTripPatterns) {
                StopLocation start = pattern.firstStop();
                end = pattern.lastStop();
                starts.put((Object)start, (Object)pattern);
                ends.put((Object)end, (Object)pattern);
                for (StopLocation stop : pattern.getStops()) {
                    vias.put((Object)stop, (Object)pattern);
                }
            }
            block6: for (TripPattern pattern : routeTripPatterns) {
                StringBuilder sb = new StringBuilder(routeName);
                end = pattern.lastStop();
                sb.append(" to " + TripPattern.stopNameAndId(end));
                if (ends.get((Object)end).size() == 1) {
                    pattern.setName(sb.toString());
                    continue;
                }
                StopLocation start = pattern.firstStop();
                sb.append(" from " + TripPattern.stopNameAndId(start));
                if (starts.get((Object)start).size() == 1) {
                    pattern.setName(sb.toString());
                    continue;
                }
                Collection tripPatterns = starts.get((Object)start);
                HashSet remainingPatterns = new HashSet(tripPatterns);
                remainingPatterns.retainAll(ends.get((Object)end));
                if (remainingPatterns.size() == 1) {
                    pattern.setName(sb.toString());
                    continue;
                }
                for (StopLocation via : pattern.getStops()) {
                    if (via.equals(start) || via.equals(end)) continue;
                    HashSet intersection = new HashSet();
                    intersection.addAll(remainingPatterns);
                    intersection.retainAll(vias.get((Object)via));
                    if (intersection.size() != 1) continue;
                    sb.append(" via " + TripPattern.stopNameAndId(via));
                    pattern.setName(sb.toString());
                    continue block6;
                }
                if (remainingPatterns.size() == 2) {
                    sb.append(" express");
                } else {
                    Trip trip = null;
                    if (!pattern.scheduledTimetable.getTripTimes().isEmpty()) {
                        trip = pattern.scheduledTimetable.getTripTimes().get(0).getTrip();
                    } else if (!pattern.scheduledTimetable.getFrequencyEntries().isEmpty()) {
                        trip = pattern.scheduledTimetable.getFrequencyEntries().get((int)0).tripTimes.getTrip();
                    }
                    if (trip != null) {
                        sb.append(" like trip ").append(trip.getId());
                    }
                }
                pattern.setName(sb.toString());
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Done generating unique names for stop patterns on each route.");
            for (Route route : patternsByRoute.keySet()) {
                routeTripPatterns = patternsByRoute.get((Object)route);
                LOG.debug("Named {} patterns in route {}", (Object)routeTripPatterns.size(), uniqueRouteNames.get(route));
                for (TripPattern pattern : routeTripPatterns) {
                    LOG.debug("    {} ({} stops)", (Object)pattern.name, (Object)pattern.stopPattern.getSize());
                }
            }
        }
    }

    public void setServiceCodes(Map<FeedScopedId, Integer> serviceCodes) {
        this.setServices(new BitSet());
        this.scheduledTripsAsStream().forEach(trip -> {
            FeedScopedId serviceId = trip.getServiceId();
            if (serviceCodes.containsKey(serviceId)) {
                this.services.set((Integer)serviceCodes.get(serviceId));
            } else {
                LOG.warn("Service " + serviceId + " not found in service codes not found.");
            }
        });
        this.scheduledTimetable.setServiceCodes(serviceCodes);
    }

    public BitSet getServices() {
        return this.services;
    }

    public void setServices(BitSet services) {
        this.services = services;
    }

    public String getTripHeadsign() {
        return this.scheduledTimetable.getTripTimes(0).getTrip().getTripHeadsign();
    }

    public static boolean idsAreUniqueAndNotNull(Collection<TripPattern> tripPatterns) {
        HashSet seen = new HashSet();
        return tripPatterns.stream().map(TransitEntity::getId).allMatch(t -> t != null && seen.add(t));
    }

    public boolean matchesModeOrSubMode(TransitMode mode, String transportSubmode) {
        return this.getMode().equals((Object)mode) || this.getNetexSubmode() != null && this.getNetexSubmode().equals(transportSubmode);
    }

    @Override
    public String toString() {
        return String.format("<TripPattern %s>", this.getId());
    }

    public String semanticHashString(Trip trip) {
        HashFunction murmur = Hashing.murmur3_32();
        BaseEncoding encoder = BaseEncoding.base64Url().omitPadding();
        StringBuilder sb = new StringBuilder(50);
        sb.append(encoder.encode(this.stopPattern.semanticHash(murmur).asBytes()));
        if (trip != null) {
            TripTimes tripTimes = this.scheduledTimetable.getTripTimes(trip);
            if (tripTimes == null) {
                return null;
            }
            sb.append(':');
            sb.append(encoder.encode(tripTimes.semanticHash(murmur).asBytes()));
        }
        return sb.toString();
    }

    public TripPattern clone() {
        try {
            return (TripPattern)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public String getFeedId() {
        return this.route.getId().getFeedId();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.scheduledTimetable.finish();
    }

    private static Coordinate coordinate(StopLocation s) {
        return new Coordinate(s.getLon(), s.getLat());
    }
}

