/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.model;

import javax.validation.constraints.NotNull;
import org.opentripplanner.model.BikeAccess;
import org.opentripplanner.model.Direction;
import org.opentripplanner.model.FeedScopedId;
import org.opentripplanner.model.Operator;
import org.opentripplanner.model.Route;
import org.opentripplanner.model.TransitEntity;
import org.opentripplanner.model.TransitMode;
import org.opentripplanner.model.TripAlteration;

public final class Trip
extends TransitEntity {
    private static final long serialVersionUID = 1L;
    private Route route;
    private Operator operator;
    private TransitMode mode;
    private String netexSubmode;
    private FeedScopedId serviceId;
    private String tripShortName;
    private String internalPlanningCode;
    private String tripHeadsign;
    private String routeShortName;
    @NotNull
    private Direction direction = Direction.UNKNOWN;
    private String blockId;
    private FeedScopedId shapeId;
    private int wheelchairAccessible = 0;
    private BikeAccess bikesAllowed = BikeAccess.UNKNOWN;
    private String fareId;
    private TripAlteration alteration = TripAlteration.PLANNED;

    public Trip(FeedScopedId id) {
        super(id);
    }

    public Trip(Trip obj) {
        this(obj.getId());
        this.route = obj.route;
        this.operator = obj.operator;
        this.serviceId = obj.serviceId;
        this.mode = obj.mode;
        this.netexSubmode = obj.netexSubmode;
        this.tripShortName = obj.tripShortName;
        this.tripHeadsign = obj.tripHeadsign;
        this.routeShortName = obj.routeShortName;
        this.direction = obj.direction;
        this.blockId = obj.blockId;
        this.shapeId = obj.shapeId;
        this.wheelchairAccessible = obj.wheelchairAccessible;
        this.bikesAllowed = obj.bikesAllowed;
        this.fareId = obj.fareId;
    }

    public Operator getOperator() {
        return this.operator != null ? this.operator : this.route.getOperator();
    }

    public Operator getTripOperator() {
        return this.operator;
    }

    public void setTripOperator(Operator operator) {
        this.operator = operator;
    }

    public Route getRoute() {
        return this.route;
    }

    public void setRoute(Route route) {
        this.route = route;
    }

    public FeedScopedId getServiceId() {
        return this.serviceId;
    }

    public void setServiceId(FeedScopedId serviceId) {
        this.serviceId = serviceId;
    }

    public TransitMode getMode() {
        return this.mode == null ? this.getRoute().getMode() : this.mode;
    }

    public void setMode(TransitMode mode) {
        this.mode = mode.equals((Object)this.getRoute().getMode()) ? null : mode;
    }

    public String getNetexSubmode() {
        return this.netexSubmode == null ? this.getRoute().getNetexSubmode() : this.netexSubmode;
    }

    public void setNetexSubmode(String netexSubmode) {
        this.netexSubmode = netexSubmode == null || netexSubmode.equals(this.getRoute().getNetexSubmode()) ? null : netexSubmode;
    }

    public String getTripShortName() {
        return this.tripShortName;
    }

    public void setTripShortName(String tripShortName) {
        this.tripShortName = tripShortName;
    }

    public String logInfo() {
        if (this.hasValue(this.tripShortName)) {
            return this.tripShortName;
        }
        if (this.hasValue(this.routeShortName)) {
            return this.routeShortName;
        }
        if (this.route != null && this.hasValue(this.route.getName())) {
            return this.route.getName();
        }
        if (this.hasValue(this.tripHeadsign)) {
            return this.tripHeadsign;
        }
        return this.getId().getId();
    }

    public String getInternalPlanningCode() {
        return this.internalPlanningCode;
    }

    public void setInternalPlanningCode(String internalPlanningCode) {
        this.internalPlanningCode = internalPlanningCode;
    }

    public String getTripHeadsign() {
        return this.tripHeadsign;
    }

    public void setTripHeadsign(String tripHeadsign) {
        this.tripHeadsign = tripHeadsign;
    }

    public String getRouteShortName() {
        return this.routeShortName;
    }

    public void setRouteShortName(String routeShortName) {
        this.routeShortName = routeShortName;
    }

    @NotNull
    public Direction getDirection() {
        return this.direction;
    }

    public String getGtfsDirectionIdAsString(String unknownValue) {
        return this.direction.equals((Object)Direction.UNKNOWN) ? unknownValue : Integer.toString(this.direction.gtfsCode);
    }

    public void setDirection(Direction direction) {
        this.direction = direction != null ? direction : Direction.UNKNOWN;
    }

    public String getBlockId() {
        return this.blockId;
    }

    public void setBlockId(String blockId) {
        this.blockId = blockId;
    }

    public FeedScopedId getShapeId() {
        return this.shapeId;
    }

    public void setShapeId(FeedScopedId shapeId) {
        this.shapeId = shapeId;
    }

    public void setWheelchairAccessible(int wheelchairAccessible) {
        this.wheelchairAccessible = wheelchairAccessible;
    }

    public int getWheelchairAccessible() {
        return this.wheelchairAccessible;
    }

    public BikeAccess getBikesAllowed() {
        return this.bikesAllowed;
    }

    public void setBikesAllowed(BikeAccess bikesAllowed) {
        this.bikesAllowed = bikesAllowed;
    }

    @Override
    public String toString() {
        return "<Trip " + this.getId() + ">";
    }

    public String getFareId() {
        return this.fareId;
    }

    public void setFareId(String fareId) {
        this.fareId = fareId;
    }

    public TripAlteration getTripAlteration() {
        return this.alteration;
    }

    public void setAlteration(TripAlteration tripAlteration) {
        if (tripAlteration != null) {
            this.alteration = tripAlteration;
        }
    }

    private boolean hasValue(String text) {
        return text != null && !text.isBlank();
    }
}

