/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.model;

import java.util.EnumSet;
import java.util.Set;

public enum TransitMode {
    RAIL,
    COACH,
    SUBWAY,
    BUS,
    TRAM,
    FERRY,
    AIRPLANE,
    CABLE_CAR,
    GONDOLA,
    FUNICULAR,
    TROLLEYBUS,
    MONORAIL;

    private static final Set<TransitMode> ON_STREET_MODES;
    private static final Set<TransitMode> NO_AIRPLANE_MODES;

    public boolean onStreet() {
        return ON_STREET_MODES.contains((Object)this);
    }

    public static Set<TransitMode> transitModesExceptAirplane() {
        return NO_AIRPLANE_MODES;
    }

    static {
        ON_STREET_MODES = EnumSet.of(COACH, BUS, TROLLEYBUS);
        NO_AIRPLANE_MODES = EnumSet.complementOf(EnumSet.of(AIRPLANE));
    }
}

