/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.model;

import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.SetMultimap;
import java.util.Collection;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.opentripplanner.model.FeedScopedId;
import org.opentripplanner.model.StopLocation;
import org.opentripplanner.model.Timetable;
import org.opentripplanner.model.TripPattern;
import org.opentripplanner.model.calendar.ServiceDate;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.mappers.TransitLayerUpdater;
import org.opentripplanner.routing.trippattern.TripTimes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimetableSnapshot {
    private static final Logger LOG = LoggerFactory.getLogger(TimetableSnapshot.class);
    private HashMap<TripPattern, SortedSet<Timetable>> timetables = new HashMap();
    private HashMap<TripIdAndServiceDate, TripPattern> lastAddedTripPattern = new HashMap();
    private SetMultimap<StopLocation, TripPattern> patternsForStop = HashMultimap.create();
    private boolean readOnly = false;
    private boolean dirty = false;
    private Set<Timetable> dirtyTimetables = new HashSet<Timetable>();

    public Timetable resolve(TripPattern pattern, ServiceDate serviceDate) {
        SortedSet<Timetable> sortedTimetables = this.timetables.get(pattern);
        if (sortedTimetables != null && serviceDate != null) {
            for (Timetable timetable : sortedTimetables) {
                if (timetable == null || !timetable.isValidFor(serviceDate)) continue;
                return timetable;
            }
        }
        return pattern.getScheduledTimetable();
    }

    public void removeRealtimeUpdatedTripTimes(TripPattern tripPattern, FeedScopedId tripId, ServiceDate serviceDate) {
        SortedSet<Timetable> sortedTimetables = this.timetables.get(tripPattern);
        if (sortedTimetables != null) {
            TripTimes tripTimesToRemove = null;
            for (Timetable timetable : sortedTimetables) {
                if (!timetable.isValidFor(serviceDate)) continue;
                int tripIndex = timetable.getTripIndex(tripId);
                if (tripIndex == -1) {
                    LOG.debug("No triptimes to remove for trip {}", (Object)tripId);
                    continue;
                }
                if (tripTimesToRemove != null) {
                    LOG.debug("Found two triptimes to remove for trip {}", (Object)tripId);
                    continue;
                }
                tripTimesToRemove = timetable.getTripTimes(tripIndex);
            }
            if (tripTimesToRemove != null) {
                for (Timetable sortedTimetable : sortedTimetables) {
                    sortedTimetable.getTripTimes().remove(tripTimesToRemove);
                }
            }
        }
    }

    public TripPattern getLastAddedTripPattern(FeedScopedId tripId, ServiceDate serviceDate) {
        TripIdAndServiceDate tripIdAndServiceDate = new TripIdAndServiceDate(tripId, serviceDate);
        TripPattern pattern = this.lastAddedTripPattern.get(tripIdAndServiceDate);
        return pattern;
    }

    public boolean update(TripPattern pattern, TripTimes updatedTripTimes, ServiceDate serviceDate) {
        int tripIndex;
        Preconditions.checkNotNull((Object)pattern);
        Preconditions.checkNotNull((Object)serviceDate);
        if (this.readOnly) {
            throw new ConcurrentModificationException("This TimetableSnapshot is read-only.");
        }
        Timetable tt = this.resolve(pattern, serviceDate);
        if (!this.dirtyTimetables.contains(tt)) {
            Timetable old = tt;
            tt = new Timetable(tt, serviceDate);
            SortedSet<Timetable> sortedTimetables = this.timetables.get(pattern);
            if (sortedTimetables == null) {
                sortedTimetables = new TreeSet<Timetable>(new SortedTimetableComparator());
            } else {
                TreeSet<Timetable> temp = new TreeSet<Timetable>(new SortedTimetableComparator());
                temp.addAll(sortedTimetables);
                sortedTimetables = temp;
            }
            if (old.getServiceDate() != null) {
                sortedTimetables.remove(old);
            }
            sortedTimetables.add(tt);
            this.timetables.put(pattern, sortedTimetables);
            this.dirtyTimetables.add(tt);
            this.dirty = true;
        }
        if ((tripIndex = tt.getTripIndex(updatedTripTimes.getTrip().getId())) == -1) {
            tt.addTripTimes(updatedTripTimes);
        } else {
            tt.setTripTimes(tripIndex, updatedTripTimes);
        }
        if (pattern.isCreatedByRealtimeUpdater()) {
            FeedScopedId tripId = updatedTripTimes.getTrip().getId();
            TripIdAndServiceDate tripIdAndServiceDate = new TripIdAndServiceDate(tripId, serviceDate);
            this.lastAddedTripPattern.put(tripIdAndServiceDate, pattern);
        }
        this.addPatternToIndex(pattern);
        return true;
    }

    public TimetableSnapshot commit() {
        return this.commit(null, false);
    }

    public TimetableSnapshot commit(TransitLayerUpdater transitLayerUpdater, boolean force) {
        if (this.readOnly) {
            throw new ConcurrentModificationException("This TimetableSnapshot is read-only.");
        }
        TimetableSnapshot ret = new TimetableSnapshot();
        if (!force && !this.isDirty()) {
            return null;
        }
        for (Timetable tt : this.dirtyTimetables) {
            tt.finish();
        }
        ret.timetables = (HashMap)this.timetables.clone();
        ret.lastAddedTripPattern = (HashMap)this.lastAddedTripPattern.clone();
        if (transitLayerUpdater != null) {
            transitLayerUpdater.update(this.dirtyTimetables);
        }
        this.dirtyTimetables.clear();
        this.dirty = false;
        ret.setPatternsForStop((SetMultimap<StopLocation, TripPattern>)HashMultimap.create(this.patternsForStop));
        ret.readOnly = true;
        return ret;
    }

    public void clear(String feedId) {
        if (this.readOnly) {
            throw new ConcurrentModificationException("This TimetableSnapshot is read-only.");
        }
        boolean timetableWasModified = this.clearTimetable(feedId);
        boolean lastAddedWasModified = this.clearLastAddedTripPattern(feedId);
        if (timetableWasModified || lastAddedWasModified) {
            this.dirty = true;
        }
    }

    protected boolean clearTimetable(String feedId) {
        return this.timetables.keySet().removeIf(tripPattern -> feedId.equals(tripPattern.getFeedId()));
    }

    protected boolean clearLastAddedTripPattern(String feedId) {
        return this.lastAddedTripPattern.keySet().removeIf(lastAddedTripPattern -> feedId.equals(lastAddedTripPattern.getTripId().getFeedId()));
    }

    public void removeLastAddedTripPattern(FeedScopedId feedScopedTripId, ServiceDate serviceDate) {
        this.lastAddedTripPattern.remove(new TripIdAndServiceDate(feedScopedTripId, serviceDate));
    }

    public boolean purgeExpiredData(ServiceDate serviceDate) {
        if (this.readOnly) {
            throw new ConcurrentModificationException("This TimetableSnapshot is read-only.");
        }
        boolean modified = false;
        Iterator<TripPattern> it = this.timetables.keySet().iterator();
        while (it.hasNext()) {
            TripPattern pattern = it.next();
            SortedSet<Timetable> sortedTimetables = this.timetables.get(pattern);
            TreeSet<Timetable> toKeepTimetables = new TreeSet<Timetable>(new SortedTimetableComparator());
            for (Timetable timetable : sortedTimetables) {
                if (serviceDate.compareTo(timetable.getServiceDate()) < 0) {
                    toKeepTimetables.add(timetable);
                    continue;
                }
                modified = true;
            }
            if (toKeepTimetables.isEmpty()) {
                it.remove();
                continue;
            }
            this.timetables.put(pattern, toKeepTimetables);
        }
        Iterator<Map.Entry<TripIdAndServiceDate, TripPattern>> iterator = this.lastAddedTripPattern.entrySet().iterator();
        while (iterator.hasNext()) {
            TripIdAndServiceDate tripIdAndServiceDate = iterator.next().getKey();
            if (serviceDate.compareTo(tripIdAndServiceDate.getServiceDate()) < 0) continue;
            iterator.remove();
            modified = true;
        }
        return modified;
    }

    public boolean isDirty() {
        if (this.readOnly) {
            return false;
        }
        return this.dirty;
    }

    public String toString() {
        String d = this.readOnly ? "committed" : String.format("%d dirty", this.dirtyTimetables.size());
        return String.format("Timetable snapshot: %d timetables (%s)", this.timetables.size(), d);
    }

    private void addPatternToIndex(TripPattern tripPattern) {
        if (tripPattern.isCreatedByRealtimeUpdater()) {
            for (StopLocation stop : tripPattern.getStops()) {
                this.patternsForStop.put((Object)stop, (Object)tripPattern);
            }
        }
    }

    public Collection<TripPattern> getPatternsForStop(StopLocation stop) {
        return this.patternsForStop.get((Object)stop);
    }

    public void setPatternsForStop(SetMultimap<StopLocation, TripPattern> patternsForStop) {
        this.patternsForStop = patternsForStop;
    }

    protected class TripIdAndServiceDate {
        private final FeedScopedId tripId;
        private final ServiceDate serviceDate;

        public TripIdAndServiceDate(FeedScopedId tripId, ServiceDate serviceDate) {
            this.tripId = tripId;
            this.serviceDate = serviceDate;
        }

        public FeedScopedId getTripId() {
            return this.tripId;
        }

        public ServiceDate getServiceDate() {
            return this.serviceDate;
        }

        public int hashCode() {
            int result = Objects.hash(this.tripId, this.serviceDate);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            TripIdAndServiceDate other = (TripIdAndServiceDate)obj;
            return Objects.equals(this.tripId, other.tripId) && Objects.equals(this.serviceDate, other.serviceDate);
        }
    }

    protected static class SortedTimetableComparator
    implements Comparator<Timetable> {
        protected SortedTimetableComparator() {
        }

        @Override
        public int compare(Timetable t1, Timetable t2) {
            return t1.getServiceDate().compareTo(t2.getServiceDate());
        }
    }
}

