/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.model;

import com.beust.jcommander.internal.Lists;
import com.google.transit.realtime.GtfsRealtime;
import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import org.opentripplanner.model.Direction;
import org.opentripplanner.model.FeedScopedId;
import org.opentripplanner.model.Trip;
import org.opentripplanner.model.TripPattern;
import org.opentripplanner.model.calendar.ServiceDate;
import org.opentripplanner.routing.core.ServiceDay;
import org.opentripplanner.routing.trippattern.FrequencyEntry;
import org.opentripplanner.routing.trippattern.TripTimes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Timetable
implements Serializable {
    private static final Logger LOG = LoggerFactory.getLogger(Timetable.class);
    private static final long serialVersionUID = 1L;
    private final TripPattern pattern;
    private final List<TripTimes> tripTimes = Lists.newArrayList();
    private final List<FrequencyEntry> frequencyEntries = Lists.newArrayList();
    private final ServiceDate serviceDate;
    private transient int minTime;
    private transient int maxTime;

    public Timetable(TripPattern pattern) {
        this.pattern = pattern;
        this.serviceDate = null;
    }

    Timetable(Timetable tt, ServiceDate serviceDate) {
        this.tripTimes.addAll(tt.tripTimes);
        this.serviceDate = serviceDate;
        this.pattern = tt.pattern;
    }

    public boolean temporallyViable(ServiceDay sd, long searchTime, int bestWait, boolean boarding) {
        if (!sd.anyServiceRunning(this.pattern.getServices())) {
            return false;
        }
        searchTime = sd.secondsSinceMidnight(searchTime);
        if (boarding ? searchTime > (long)this.maxTime : searchTime < (long)this.minTime) {
            return false;
        }
        if (bestWait >= 0) {
            long bestTime;
            long l = bestTime = boarding ? searchTime + (long)bestWait : searchTime - (long)bestWait;
            if (boarding ? bestTime < (long)this.minTime : bestTime > (long)this.maxTime) {
                return false;
            }
        }
        return true;
    }

    public void finish() {
        int nStops = this.pattern.numberOfStops();
        List allTripTimes = Lists.newArrayList(this.tripTimes);
        for (FrequencyEntry freq : this.frequencyEntries) {
            allTripTimes.add(freq.tripTimes);
        }
        this.minTime = Integer.MAX_VALUE;
        this.maxTime = Integer.MIN_VALUE;
        for (TripTimes tt : this.tripTimes) {
            this.minTime = Math.min(this.minTime, tt.getDepartureTime(0));
            this.maxTime = Math.max(this.maxTime, tt.getArrivalTime(nStops - 1));
        }
        for (FrequencyEntry freq : this.frequencyEntries) {
            this.minTime = Math.min(this.minTime, freq.getMinDeparture());
            this.maxTime = Math.max(this.maxTime, freq.getMaxArrival());
        }
    }

    public int getTripIndex(FeedScopedId tripId) {
        int ret = 0;
        for (TripTimes tt : this.tripTimes) {
            if (tt.getTrip().getId().equals(tripId)) {
                return ret;
            }
            ++ret;
        }
        return -1;
    }

    public int getTripIndex(String tripId) {
        int ret = 0;
        for (TripTimes tt : this.tripTimes) {
            if (tt.getTrip().getId().getId().equals(tripId)) {
                return ret;
            }
            ++ret;
        }
        return -1;
    }

    public TripTimes getTripTimes(int tripIndex) {
        return this.tripTimes.get(tripIndex);
    }

    public TripTimes getTripTimes(Trip trip) {
        for (TripTimes tt : this.tripTimes) {
            if (tt.getTrip() != trip) continue;
            return tt;
        }
        return null;
    }

    public TripTimes setTripTimes(int tripIndex, TripTimes tt) {
        return this.tripTimes.set(tripIndex, tt);
    }

    /*
     * Enabled aggressive block sorting
     */
    public TripTimes createUpdatedTripTimes(GtfsRealtime.TripUpdate tripUpdate, TimeZone timeZone, ServiceDate updateServiceDate) {
        TripTimes newTimes;
        String tripId;
        block29: {
            block28: {
                if (tripUpdate == null) {
                    LOG.error("A null TripUpdate pointer was passed to the Timetable class update method.");
                    return null;
                }
                if (!tripUpdate.hasTrip()) {
                    LOG.error("TripUpdate object has no TripDescriptor field.");
                    return null;
                }
                GtfsRealtime.TripDescriptor tripDescriptor = tripUpdate.getTrip();
                if (!tripDescriptor.hasTripId()) {
                    LOG.error("TripDescriptor object has no TripId field");
                    return null;
                }
                tripId = tripDescriptor.getTripId();
                int tripIndex = this.getTripIndex(tripId);
                if (tripIndex == -1) {
                    LOG.info("tripId {} not found in pattern.", (Object)tripId);
                    return null;
                }
                LOG.trace("tripId {} found at index {} in timetable.", (Object)tripId, (Object)tripIndex);
                newTimes = new TripTimes(this.getTripTimes(tripIndex));
                if (!tripDescriptor.hasScheduleRelationship() || tripDescriptor.getScheduleRelationship() != GtfsRealtime.TripDescriptor.ScheduleRelationship.CANCELED) break block28;
                newTimes.cancelTrip();
                break block29;
            }
            Iterator<GtfsRealtime.TripUpdate.StopTimeUpdate> updates = tripUpdate.getStopTimeUpdateList().iterator();
            if (!updates.hasNext()) {
                LOG.warn("Won't apply zero-length trip update to trip {}.", (Object)tripId);
                return null;
            }
            GtfsRealtime.TripUpdate.StopTimeUpdate update = updates.next();
            int numStops = newTimes.getNumStops();
            Integer delay = null;
            long today = updateServiceDate.getAsDate(timeZone).getTime() / 1000L;
            for (int i = 0; i < numStops; ++i) {
                block30: {
                    block27: {
                        block33: {
                            block26: {
                                block32: {
                                    block31: {
                                        GtfsRealtime.TripUpdate.StopTimeUpdate.ScheduleRelationship scheduleRelationship;
                                        boolean match = false;
                                        if (update != null) {
                                            if (update.hasStopSequence()) {
                                                match = update.getStopSequence() == newTimes.getOriginalGtfsStopSequence(i);
                                            } else if (update.hasStopId()) {
                                                match = this.pattern.getStop(i).getId().getId().equals(update.getStopId());
                                            }
                                        }
                                        if (!match) break block30;
                                        GtfsRealtime.TripUpdate.StopTimeUpdate.ScheduleRelationship scheduleRelationship2 = scheduleRelationship = update.hasScheduleRelationship() ? update.getScheduleRelationship() : GtfsRealtime.TripUpdate.StopTimeUpdate.ScheduleRelationship.SCHEDULED;
                                        if (scheduleRelationship == GtfsRealtime.TripUpdate.StopTimeUpdate.ScheduleRelationship.SKIPPED) {
                                            LOG.warn("Partially canceled trips are unsupported by this method. Skipping TripUpdate.");
                                            return null;
                                        }
                                        if (scheduleRelationship != GtfsRealtime.TripUpdate.StopTimeUpdate.ScheduleRelationship.NO_DATA) break block31;
                                        newTimes.updateArrivalDelay(i, 0);
                                        newTimes.updateDepartureDelay(i, 0);
                                        delay = 0;
                                        break block27;
                                    }
                                    if (!update.hasArrival()) break block32;
                                    GtfsRealtime.TripUpdate.StopTimeEvent arrival = update.getArrival();
                                    if (arrival.hasDelay()) {
                                        delay = arrival.getDelay();
                                        if (arrival.hasTime()) {
                                            newTimes.updateArrivalTime(i, (int)(arrival.getTime() - today));
                                            break block26;
                                        } else {
                                            newTimes.updateArrivalDelay(i, delay);
                                        }
                                        break block26;
                                    } else {
                                        if (!arrival.hasTime()) {
                                            LOG.error("Arrival time at index {} is erroneous.", (Object)i);
                                            return null;
                                        }
                                        newTimes.updateArrivalTime(i, (int)(arrival.getTime() - today));
                                        delay = newTimes.getArrivalDelay(i);
                                    }
                                    break block26;
                                }
                                if (delay != null) {
                                    newTimes.updateArrivalDelay(i, delay);
                                }
                            }
                            if (!update.hasDeparture()) break block33;
                            GtfsRealtime.TripUpdate.StopTimeEvent departure = update.getDeparture();
                            if (departure.hasDelay()) {
                                delay = departure.getDelay();
                                if (departure.hasTime()) {
                                    newTimes.updateDepartureTime(i, (int)(departure.getTime() - today));
                                    break block27;
                                } else {
                                    newTimes.updateDepartureDelay(i, delay);
                                }
                                break block27;
                            } else {
                                if (!departure.hasTime()) {
                                    LOG.error("Departure time at index {} is erroneous.", (Object)i);
                                    return null;
                                }
                                newTimes.updateDepartureTime(i, (int)(departure.getTime() - today));
                                delay = newTimes.getDepartureDelay(i);
                            }
                            break block27;
                        }
                        if (delay != null) {
                            newTimes.updateDepartureDelay(i, delay);
                        }
                    }
                    if (updates.hasNext()) {
                        update = updates.next();
                        continue;
                    }
                    update = null;
                    continue;
                }
                if (delay == null) continue;
                newTimes.updateArrivalDelay(i, delay);
                newTimes.updateDepartureDelay(i, delay);
            }
            if (update != null) {
                LOG.error("Part of a TripUpdate object could not be applied successfully to trip {}.", (Object)tripId);
                return null;
            }
        }
        if (!newTimes.timesIncreasing()) {
            LOG.error("TripTimes are non-increasing after applying GTFS-RT delay propagation to trip {}.", (Object)tripId);
            return null;
        }
        LOG.debug("A valid TripUpdate object was applied to trip {} using the Timetable class update method.", (Object)tripId);
        return newTimes;
    }

    public void addTripTimes(TripTimes tt) {
        this.tripTimes.add(tt);
    }

    public void addFrequencyEntry(FrequencyEntry freq) {
        this.frequencyEntries.add(freq);
    }

    public boolean isValidFor(ServiceDate serviceDate) {
        return this.serviceDate == null || this.serviceDate.equals(serviceDate);
    }

    public void setServiceCodes(Map<FeedScopedId, Integer> serviceCodes) {
        for (TripTimes tt : this.tripTimes) {
            tt.setServiceCode(serviceCodes.get(tt.getTrip().getServiceId()));
        }
        for (FrequencyEntry freq : this.frequencyEntries) {
            TripTimes tt = freq.tripTimes;
            tt.setServiceCode(serviceCodes.get(tt.getTrip().getServiceId()));
        }
    }

    public TripPattern getPattern() {
        return this.pattern;
    }

    public List<TripTimes> getTripTimes() {
        return this.tripTimes;
    }

    public List<FrequencyEntry> getFrequencyEntries() {
        return this.frequencyEntries;
    }

    public ServiceDate getServiceDate() {
        return this.serviceDate;
    }

    public Direction getDirection() {
        if (!this.tripTimes.isEmpty()) {
            return this.tripTimes.get(0).getTrip().getDirection();
        }
        if (!this.frequencyEntries.isEmpty()) {
            return this.frequencyEntries.get((int)0).tripTimes.getTrip().getDirection();
        }
        return Direction.UNKNOWN;
    }
}

