/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.model;

import java.util.List;
import org.opentripplanner.model.BookingInfo;
import org.opentripplanner.model.PickDrop;
import org.opentripplanner.model.StopLocation;
import org.opentripplanner.model.StopTimeKey;
import org.opentripplanner.model.Trip;
import org.opentripplanner.util.time.TimeUtils;

public final class StopTime
implements Comparable<StopTime> {
    public static final int MISSING_VALUE = -999;
    private Trip trip;
    private StopLocation stop;
    private int arrivalTime = -999;
    private int departureTime = -999;
    private int timepoint = -999;
    private int stopSequence;
    private String stopHeadsign;
    private List<String> headsignVias;
    private String routeShortName;
    private PickDrop pickupType = PickDrop.SCHEDULED;
    private PickDrop dropOffType = PickDrop.SCHEDULED;
    private double shapeDistTraveled = -999.0;
    private String farePeriodId;
    private int flexWindowStart = -999;
    private int flexWindowEnd = -999;
    private int flexContinuousPickup = -999;
    private int flexContinuousDropOff = -999;
    private BookingInfo dropOffBookingInfo;
    private BookingInfo pickupBookingInfo;

    public StopTime() {
    }

    public StopTime(StopTime st) {
        this.trip = st.trip;
        this.stop = st.stop;
        this.arrivalTime = st.arrivalTime;
        this.departureTime = st.departureTime;
        this.timepoint = st.timepoint;
        this.stopSequence = st.stopSequence;
        this.stopHeadsign = st.stopHeadsign;
        this.routeShortName = st.routeShortName;
        this.pickupType = st.pickupType;
        this.dropOffType = st.dropOffType;
        this.shapeDistTraveled = st.shapeDistTraveled;
        this.farePeriodId = st.farePeriodId;
        this.flexWindowStart = st.flexWindowStart;
        this.flexWindowEnd = st.flexWindowEnd;
        this.flexContinuousPickup = st.flexContinuousPickup;
        this.flexContinuousDropOff = st.flexContinuousDropOff;
        this.dropOffBookingInfo = st.dropOffBookingInfo;
        this.pickupBookingInfo = st.pickupBookingInfo;
        this.headsignVias = st.headsignVias;
    }

    public StopTimeKey getId() {
        return new StopTimeKey(this.trip.getId(), this.stopSequence);
    }

    public Trip getTrip() {
        return this.trip;
    }

    public void setTrip(Trip trip) {
        this.trip = trip;
    }

    public int getStopSequence() {
        return this.stopSequence;
    }

    public void setStopSequence(int stopSequence) {
        this.stopSequence = stopSequence;
    }

    public StopLocation getStop() {
        return this.stop;
    }

    public void setStop(StopLocation stop) {
        this.stop = stop;
    }

    public boolean isArrivalTimeSet() {
        return this.arrivalTime != -999;
    }

    public int getArrivalTime() {
        return this.arrivalTime;
    }

    public void setArrivalTime(int arrivalTime) {
        this.arrivalTime = arrivalTime;
    }

    public void clearArrivalTime() {
        this.arrivalTime = -999;
    }

    public boolean isDepartureTimeSet() {
        return this.departureTime != -999;
    }

    public int getDepartureTime() {
        return this.departureTime;
    }

    public void setDepartureTime(int departureTime) {
        this.departureTime = departureTime;
    }

    public void clearDepartureTime() {
        this.departureTime = -999;
    }

    public boolean isTimepointSet() {
        return this.timepoint != -999;
    }

    public int getTimepoint() {
        return this.timepoint;
    }

    public void setTimepoint(int timepoint) {
        this.timepoint = timepoint;
    }

    public void clearTimepoint() {
        this.timepoint = -999;
    }

    public String getStopHeadsign() {
        return this.stopHeadsign;
    }

    public void setStopHeadsign(String headSign) {
        this.stopHeadsign = headSign;
    }

    public String getRouteShortName() {
        return this.routeShortName;
    }

    public void setRouteShortName(String routeShortName) {
        this.routeShortName = routeShortName;
    }

    public PickDrop getPickupType() {
        return this.pickupType;
    }

    public void setPickupType(PickDrop pickupType) {
        this.pickupType = pickupType;
    }

    public PickDrop getDropOffType() {
        return this.dropOffType;
    }

    public void setDropOffType(PickDrop dropOffType) {
        this.dropOffType = dropOffType;
    }

    public boolean isShapeDistTraveledSet() {
        return this.shapeDistTraveled != -999.0;
    }

    public double getShapeDistTraveled() {
        return this.shapeDistTraveled;
    }

    public void setShapeDistTraveled(double shapeDistTraveled) {
        this.shapeDistTraveled = shapeDistTraveled;
    }

    public void clearShapeDistTraveled() {
        this.shapeDistTraveled = -999.0;
    }

    public String getFarePeriodId() {
        return this.farePeriodId;
    }

    public void setFarePeriodId(String farePeriodId) {
        this.farePeriodId = farePeriodId;
    }

    public void setFlexWindowStart(int flexWindowStart) {
        this.flexWindowStart = flexWindowStart;
    }

    public int getFlexWindowStart() {
        return this.flexWindowStart;
    }

    public void setFlexWindowEnd(int flexWindowEnd) {
        this.flexWindowEnd = flexWindowEnd;
    }

    public int getFlexWindowEnd() {
        return this.flexWindowEnd;
    }

    public int getFlexContinuousPickup() {
        return this.flexContinuousPickup == -999 ? 1 : this.flexContinuousPickup;
    }

    public void setFlexContinuousPickup(int flexContinuousPickup) {
        this.flexContinuousPickup = flexContinuousPickup;
    }

    public int getFlexContinuousDropOff() {
        return this.flexContinuousDropOff == -999 ? 1 : this.flexContinuousDropOff;
    }

    public void setFlexContinuousDropOff(int flexContinuousDropOff) {
        this.flexContinuousDropOff = flexContinuousDropOff;
    }

    public BookingInfo getDropOffBookingInfo() {
        return this.dropOffBookingInfo;
    }

    public void setDropOffBookingInfo(BookingInfo dropOffBookingInfo) {
        this.dropOffBookingInfo = dropOffBookingInfo;
    }

    public BookingInfo getPickupBookingInfo() {
        return this.pickupBookingInfo;
    }

    public void setPickupBookingInfo(BookingInfo pickupBookingInfo) {
        this.pickupBookingInfo = pickupBookingInfo;
    }

    public List<String> getHeadsignVias() {
        return this.headsignVias;
    }

    public void setHeadsignVias(List<String> headsignVias) {
        this.headsignVias = headsignVias;
    }

    @Override
    public int compareTo(StopTime o) {
        return this.getStopSequence() - o.getStopSequence();
    }

    public void cancel() {
        this.pickupType = PickDrop.CANCELLED;
        this.dropOffType = PickDrop.CANCELLED;
    }

    public void cancelDropOff() {
        this.dropOffType = PickDrop.CANCELLED;
    }

    public void cancelPickup() {
        this.pickupType = PickDrop.CANCELLED;
    }

    public String toString() {
        return "StopTime(seq=" + this.getStopSequence() + " stop=" + this.getStop().getId() + " trip=" + this.getTrip().getId() + " times=" + TimeUtils.timeToStrLong(this.getArrivalTime()) + "-" + TimeUtils.timeToStrLong(this.getDepartureTime()) + ")";
    }
}

