/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.model;

import com.google.common.hash.HashCode;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hasher;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import org.opentripplanner.model.FlexStopLocation;
import org.opentripplanner.model.PickDrop;
import org.opentripplanner.model.Station;
import org.opentripplanner.model.StopLocation;
import org.opentripplanner.model.StopTime;

public final class StopPattern
implements Serializable {
    private static final long serialVersionUID = 20140101L;
    public static final int NOT_FOUND = -1;
    private final StopLocation[] stops;
    private final PickDrop[] pickups;
    private final PickDrop[] dropoffs;

    private StopPattern(int size) {
        this.stops = new StopLocation[size];
        this.pickups = new PickDrop[size];
        this.dropoffs = new PickDrop[size];
    }

    public StopPattern(Collection<StopTime> stopTimes) {
        this(stopTimes.size());
        int size = stopTimes.size();
        if (size == 0) {
            return;
        }
        Iterator<StopTime> stopTimeIterator = stopTimes.iterator();
        for (int i = 0; i < size; ++i) {
            StopTime stopTime = stopTimeIterator.next();
            this.stops[i] = stopTime.getStop();
            this.pickups[i] = StopPattern.computePickDrop(stopTime.getStop(), stopTime.getPickupType());
            this.dropoffs[i] = StopPattern.computePickDrop(stopTime.getStop(), stopTime.getDropOffType());
        }
    }

    int getSize() {
        return this.stops.length;
    }

    int findStopPosition(StopLocation stop) {
        for (int i = 0; i < this.stops.length; ++i) {
            if (this.stops[i] != stop) continue;
            return i;
        }
        return -1;
    }

    int findBoardingPosition(StopLocation stop) {
        return this.findStopPosition(0, this.stops.length - 1, s -> s == stop);
    }

    int findAlightPosition(StopLocation stop) {
        return this.findStopPosition(1, this.stops.length, s -> s == stop);
    }

    int findBoardingPosition(Station station) {
        return this.findStopPosition(0, this.stops.length - 1, station::includes);
    }

    int findAlightPosition(Station station) {
        return this.findStopPosition(1, this.stops.length, station::includes);
    }

    public boolean equals(Object other) {
        if (other instanceof StopPattern) {
            StopPattern that = (StopPattern)other;
            return Arrays.equals(this.stops, that.stops) && Arrays.equals((Object[])this.pickups, (Object[])that.pickups) && Arrays.equals((Object[])this.dropoffs, (Object[])that.dropoffs);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.stops.length;
        hash += Arrays.hashCode(this.stops);
        hash *= 31;
        hash += Arrays.hashCode((Object[])this.pickups);
        hash *= 31;
        return hash += Arrays.hashCode((Object[])this.dropoffs);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("StopPattern: ");
        int j = this.stops.length;
        for (int i = 0; i < j; ++i) {
            sb.append(String.format("%s_%s%s ", new Object[]{this.stops[i].getCode(), this.pickups[i], this.dropoffs[i]}));
        }
        return sb.toString();
    }

    HashCode semanticHash(HashFunction hashFunction) {
        Hasher hasher = hashFunction.newHasher();
        int size = this.stops.length;
        for (int s = 0; s < size; ++s) {
            StopLocation stop = this.stops[s];
            hasher.putLong((long)(stop.getLat() * 1000000.0));
            hasher.putLong((long)(stop.getLon() * 1000000.0));
        }
        for (int hop = 0; hop < size - 1; ++hop) {
            hasher.putInt(this.pickups[hop].getGtfsCode());
            hasher.putInt(this.dropoffs[hop + 1].getGtfsCode());
        }
        return hasher.hash();
    }

    List<StopLocation> getStops() {
        return List.of(this.stops);
    }

    StopLocation getStop(int stopPosInPattern) {
        return this.stops[stopPosInPattern];
    }

    PickDrop getPickup(int stopPosInPattern) {
        return this.pickups[stopPosInPattern];
    }

    PickDrop getDropoff(int stopPosInPattern) {
        return this.dropoffs[stopPosInPattern];
    }

    boolean canAlight(int stopPosInPattern) {
        return this.dropoffs[stopPosInPattern].isRoutable();
    }

    boolean canBoard(int stopPosInPattern) {
        return this.pickups[stopPosInPattern].isRoutable();
    }

    boolean canBoard(StopLocation stop) {
        for (int i = 0; i < this.stops.length - 1; ++i) {
            if (stop != this.stops[i] || !this.canBoard(i)) continue;
            return true;
        }
        return false;
    }

    private static PickDrop computePickDrop(StopLocation stop, PickDrop pickDrop) {
        if (stop instanceof FlexStopLocation) {
            return PickDrop.NONE;
        }
        return pickDrop;
    }

    private int findStopPosition(int start, int end, Predicate<StopLocation> match) {
        for (int i = start; i < end; ++i) {
            if (!match.test(this.stops[i])) continue;
            return i;
        }
        return -1;
    }
}

