/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.model;

import java.util.Collection;
import java.util.List;
import java.util.TimeZone;
import org.locationtech.jts.geom.Geometry;
import org.opentripplanner.model.FareZone;
import org.opentripplanner.model.FeedScopedId;
import org.opentripplanner.model.Station;
import org.opentripplanner.model.StopTransferPriority;
import org.opentripplanner.model.TransitMode;
import org.opentripplanner.model.WgsCoordinate;
import org.opentripplanner.model.WheelChairBoarding;

public interface StopLocation {
    public FeedScopedId getId();

    public String getName();

    public String getDescription();

    public String getUrl();

    default public String getCode() {
        return null;
    }

    default public String getPlatformCode() {
        return null;
    }

    default public TransitMode getVehicleType() {
        return null;
    }

    default public String getVehicleSubmode() {
        return null;
    }

    default public double getLat() {
        return this.getCoordinate().latitude();
    }

    default public double getLon() {
        return this.getCoordinate().longitude();
    }

    default public Station getParentStation() {
        return null;
    }

    default public Collection<FareZone> getFareZones() {
        return List.of();
    }

    default public WheelChairBoarding getWheelchairBoarding() {
        return null;
    }

    default public String getFirstZoneAsString() {
        return this.getFareZones().stream().map(t -> t.getId().getId()).findFirst().orElse(null);
    }

    public WgsCoordinate getCoordinate();

    public Geometry getGeometry();

    default public TimeZone getTimeZone() {
        return null;
    }

    public boolean isPartOfStation();

    default public StopTransferPriority getPriority() {
        return StopTransferPriority.ALLOWED;
    }

    public boolean isPartOfSameStationAs(StopLocation var1);
}

