/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.model;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.TimeZone;
import javax.validation.constraints.NotNull;
import org.locationtech.jts.geom.Geometry;
import org.opentripplanner.common.geometry.GeometryUtils;
import org.opentripplanner.model.BoardingArea;
import org.opentripplanner.model.FareZone;
import org.opentripplanner.model.FeedScopedId;
import org.opentripplanner.model.Station;
import org.opentripplanner.model.StationElement;
import org.opentripplanner.model.StopLevel;
import org.opentripplanner.model.StopLocation;
import org.opentripplanner.model.StopTransferPriority;
import org.opentripplanner.model.TransitMode;
import org.opentripplanner.model.WgsCoordinate;
import org.opentripplanner.model.WheelChairBoarding;

public final class Stop
extends StationElement
implements StopLocation {
    private static final long serialVersionUID = 2L;
    private final Collection<FareZone> fareZones;
    private final String platformCode;
    private final String url;
    private final TimeZone timeZone;
    private final TransitMode vehicleType;
    private final String netexSubmode;
    private HashSet<BoardingArea> boardingAreas;

    public Stop(FeedScopedId id, String name, String code, String description, WgsCoordinate coordinate, WheelChairBoarding wheelchairBoarding, StopLevel level, String platformCode, Collection<FareZone> fareZones, String url, TimeZone timeZone, TransitMode vehicleType, String netexSubmode) {
        super(id, name, code, description, coordinate, wheelchairBoarding, level);
        this.platformCode = platformCode;
        this.fareZones = fareZones;
        this.url = url;
        this.timeZone = timeZone;
        this.vehicleType = vehicleType;
        this.netexSubmode = netexSubmode;
    }

    public static Stop stopForTest(String idAndName, double lat, double lon) {
        return Stop.stopForTest(idAndName, lat, lon, null);
    }

    public static Stop stopForTest(String idAndName, double lat, double lon, Station parent) {
        Stop stop = new Stop(new FeedScopedId("F", idAndName), idAndName, idAndName, null, new WgsCoordinate(lat, lon), null, null, null, null, null, null, null, null);
        stop.setParentStation(parent);
        return stop;
    }

    public void addBoardingArea(BoardingArea boardingArea) {
        if (this.boardingAreas == null) {
            this.boardingAreas = new HashSet();
        }
        this.boardingAreas.add(boardingArea);
    }

    @Override
    public String toString() {
        return "<Stop " + this.getId() + ">";
    }

    @Override
    public String getPlatformCode() {
        return this.platformCode;
    }

    @Override
    public String getUrl() {
        return this.url;
    }

    @Override
    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    @Override
    public TransitMode getVehicleType() {
        return this.vehicleType;
    }

    public Collection<BoardingArea> getBoardingAreas() {
        return this.boardingAreas != null ? this.boardingAreas : Collections.emptySet();
    }

    @Override
    @NotNull
    public StopTransferPriority getPriority() {
        return this.isPartOfStation() ? this.getParentStation().getPriority() : StopTransferPriority.ALLOWED;
    }

    @Override
    public Collection<FareZone> getFareZones() {
        return Collections.unmodifiableCollection(this.fareZones);
    }

    @Override
    public Geometry getGeometry() {
        return GeometryUtils.getGeometryFactory().createPoint(this.getCoordinate().asJtsCoordinate());
    }

    @Override
    public String getVehicleSubmode() {
        return this.netexSubmode;
    }
}

