/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.model;

import javax.annotation.Nonnull;
import org.opentripplanner.model.FeedScopedId;
import org.opentripplanner.model.Station;
import org.opentripplanner.model.StopLevel;
import org.opentripplanner.model.StopLocation;
import org.opentripplanner.model.TransitEntity;
import org.opentripplanner.model.WgsCoordinate;
import org.opentripplanner.model.WheelChairBoarding;

public abstract class StationElement
extends TransitEntity {
    private final String name;
    private final String code;
    private final String description;
    private final WgsCoordinate coordinate;
    private final WheelChairBoarding wheelchairBoarding;
    private final StopLevel level;
    private Station parentStation;

    public StationElement(FeedScopedId id, String name, String code, String description, WgsCoordinate coordinate, WheelChairBoarding wheelchairBoarding, StopLevel level) {
        super(id);
        this.name = name;
        this.code = code;
        this.description = description;
        this.coordinate = coordinate;
        this.wheelchairBoarding = wheelchairBoarding;
        this.level = level;
    }

    @Nonnull
    public String getName() {
        return this.name;
    }

    public String getCode() {
        return this.code;
    }

    public String getDescription() {
        return this.description;
    }

    public WgsCoordinate getCoordinate() {
        if (this.coordinate != null) {
            return this.coordinate;
        }
        if (this.parentStation != null) {
            return this.parentStation.getCoordinate();
        }
        throw new IllegalStateException("Coordinate not set for: " + this.toString());
    }

    boolean isCoordinateSet() {
        return this.coordinate != null;
    }

    public WheelChairBoarding getWheelchairBoarding() {
        return this.wheelchairBoarding;
    }

    public String getLevelName() {
        return this.level == null ? null : this.level.getName();
    }

    public Double getLevelIndex() {
        return this.level == null ? null : Double.valueOf(this.level.getIndex());
    }

    public Station getParentStation() {
        return this.parentStation;
    }

    public boolean isPartOfStation() {
        return this.parentStation != null;
    }

    public boolean isPartOfSameStationAs(StopLocation other) {
        if (other == null) {
            return false;
        }
        return this.isPartOfStation() && this.parentStation.equals(other.getParentStation());
    }

    public void setParentStation(Station parentStation) {
        this.parentStation = parentStation;
    }
}

