/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.model;

import com.fasterxml.jackson.annotation.JsonBackReference;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.TimeZone;
import java.util.stream.Collectors;
import org.locationtech.jts.algorithm.ConvexHull;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.Point;
import org.opentripplanner.common.geometry.GeometryUtils;
import org.opentripplanner.model.FeedScopedId;
import org.opentripplanner.model.Stop;
import org.opentripplanner.model.StopCollection;
import org.opentripplanner.model.StopLocation;
import org.opentripplanner.model.StopTransferPriority;
import org.opentripplanner.model.TransitEntity;
import org.opentripplanner.model.WgsCoordinate;

public class Station
extends TransitEntity
implements StopCollection {
    private static final long serialVersionUID = 1L;
    public static final StopTransferPriority DEFAULT_PRIORITY = StopTransferPriority.ALLOWED;
    private final String name;
    private final String code;
    private final String description;
    private final WgsCoordinate coordinate;
    private final StopTransferPriority priority;
    private GeometryCollection geometry;
    private final String url;
    private final TimeZone timezone;
    @JsonBackReference
    private final Set<StopLocation> childStops = new HashSet<StopLocation>();

    public Station(FeedScopedId id, String name, WgsCoordinate coordinate, String code, String description, String url, TimeZone timezone, StopTransferPriority priority) {
        super(id);
        this.name = name;
        this.coordinate = coordinate;
        this.code = code;
        this.description = description;
        this.url = url;
        this.timezone = timezone;
        this.priority = priority == null ? DEFAULT_PRIORITY : priority;
        this.geometry = Station.computeGeometry(coordinate, Set.of());
    }

    public static Station stationForTest(String idAndName, double lat, double lon) {
        return new Station(new FeedScopedId("F", idAndName), idAndName, new WgsCoordinate(lat, lon), idAndName, "Station " + idAndName, null, null, StopTransferPriority.ALLOWED);
    }

    public void addChildStop(Stop stop) {
        this.childStops.add(stop);
        this.geometry = Station.computeGeometry(this.coordinate, this.childStops);
    }

    public boolean includes(StopLocation stop) {
        return this.childStops.contains(stop);
    }

    @Override
    public String toString() {
        return "<Station " + this.getId() + ">";
    }

    public String getName() {
        return this.name;
    }

    public WgsCoordinate getCoordinate() {
        return this.coordinate;
    }

    public String getCode() {
        return this.code;
    }

    public String getDescription() {
        return this.description;
    }

    public String getUrl() {
        return this.url;
    }

    public StopTransferPriority getPriority() {
        return this.priority;
    }

    public TimeZone getTimezone() {
        return this.timezone;
    }

    @Override
    public Collection<StopLocation> getChildStops() {
        return this.childStops;
    }

    @Override
    public double getLat() {
        return this.coordinate.latitude();
    }

    @Override
    public double getLon() {
        return this.coordinate.longitude();
    }

    public GeometryCollection getGeometry() {
        return this.geometry;
    }

    private static GeometryCollection computeGeometry(WgsCoordinate coordinate, Set<StopLocation> childStops) {
        Geometry[] geometryArray;
        Point stationPoint = null;
        List<Geometry> childGeometries = childStops.stream().map(StopLocation::getGeometry).filter(Objects::nonNull).collect(Collectors.toList());
        if (coordinate != null) {
            stationPoint = GeometryUtils.getGeometryFactory().createPoint(coordinate.asJtsCoordinate());
            childGeometries.add((Geometry)stationPoint);
        }
        GeometryCollection geometryCollection = GeometryUtils.getGeometryFactory().createGeometryCollection(childGeometries.toArray(new Geometry[0]));
        Geometry convexHull = new ConvexHull((Geometry)geometryCollection).getConvexHull();
        if (stationPoint != null) {
            Geometry[] geometryArray2 = new Geometry[2];
            geometryArray2[0] = stationPoint;
            geometryArray = geometryArray2;
            geometryArray2[1] = convexHull;
        } else {
            Geometry[] geometryArray3 = new Geometry[1];
            geometryArray = geometryArray3;
            geometryArray3[0] = convexHull;
        }
        Geometry[] geometries = geometryArray;
        return GeometryUtils.getGeometryFactory().createGeometryCollection(geometries);
    }
}

