/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.model;

public enum PickDrop {
    SCHEDULED(true, 0),
    NONE(false, 1),
    CALL_AGENCY(true, 2),
    COORDINATE_WITH_DRIVER(true, 3),
    CANCELLED(false, -1);

    private final boolean routable;
    private final int gtfsCode;

    private PickDrop(boolean routable, int gtfsCode) {
        this.routable = routable;
        this.gtfsCode = gtfsCode;
    }

    public boolean is(PickDrop value) {
        return this == value;
    }

    public boolean isRoutable() {
        return this.routable;
    }

    public boolean isNotRoutable() {
        return !this.routable;
    }

    public int getGtfsCode() {
        return this.gtfsCode;
    }

    public static PickDrop fromGtfsCode(int gtfsCode) {
        for (PickDrop pickDrop : PickDrop.values()) {
            if (pickDrop.gtfsCode != gtfsCode) continue;
            return pickDrop;
        }
        throw new IllegalArgumentException("Not a valid gtfs code: " + gtfsCode);
    }
}

