/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.stream.Collectors;
import org.opentripplanner.model.FeedScopedId;
import org.opentripplanner.model.Station;
import org.opentripplanner.model.StopCollection;
import org.opentripplanner.model.StopLocation;
import org.opentripplanner.model.TransitEntity;
import org.opentripplanner.model.WgsCoordinate;

public class MultiModalStation
extends TransitEntity
implements StopCollection {
    private static final long serialVersionUID = 1L;
    private final Collection<Station> childStations;
    private String name;
    private WgsCoordinate coordinate;
    private String code;
    private String description;
    private String url;

    public MultiModalStation(FeedScopedId id, Collection<Station> children) {
        super(id);
        this.childStations = Collections.unmodifiableCollection(new ArrayList<Station>(children));
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public double getLat() {
        return this.coordinate.latitude();
    }

    @Override
    public double getLon() {
        return this.coordinate.longitude();
    }

    public void setCoordinate(WgsCoordinate coordinate) {
        this.coordinate = coordinate;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    @Override
    public Collection<StopLocation> getChildStops() {
        return this.childStations.stream().flatMap(s -> s.getChildStops().stream()).collect(Collectors.toUnmodifiableList());
    }

    public Collection<Station> getChildStations() {
        return this.childStations;
    }

    @Override
    public String toString() {
        return "<MultiModal station " + this.getId() + ">";
    }
}

