/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.model;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.opentripplanner.model.FeedScopedId;
import org.opentripplanner.model.StopCollection;
import org.opentripplanner.model.StopLocation;
import org.opentripplanner.model.TransitEntity;
import org.opentripplanner.model.WgsCoordinate;

public class GroupOfStations
extends TransitEntity
implements StopCollection {
    private static final long serialVersionUID = 1L;
    private String name;
    private PurposeOfGrouping purposeOfGrouping;
    private WgsCoordinate coordinate;
    private Set<StopCollection> childStations = new HashSet<StopCollection>();

    public GroupOfStations(FeedScopedId id) {
        super(id);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public double getLat() {
        return this.coordinate.latitude();
    }

    @Override
    public double getLon() {
        return this.coordinate.longitude();
    }

    public void setCoordinate(WgsCoordinate coordinate) {
        this.coordinate = coordinate;
    }

    @Override
    public Collection<StopLocation> getChildStops() {
        return this.childStations.stream().flatMap(s -> s.getChildStops().stream()).collect(Collectors.toUnmodifiableList());
    }

    public Collection<StopCollection> getChildStations() {
        return this.childStations;
    }

    public void addChildStation(StopCollection station) {
        this.childStations.add(station);
    }

    public PurposeOfGrouping getPurposeOfGrouping() {
        return this.purposeOfGrouping;
    }

    public void setPurposeOfGrouping(PurposeOfGrouping purposeOfGrouping) {
        this.purposeOfGrouping = purposeOfGrouping;
    }

    @Override
    public String toString() {
        return "<GroupOfStations " + this.getId() + ">";
    }

    public static enum PurposeOfGrouping {
        GENERALIZATION,
        CLUSTER;

    }
}

