/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.model;

import java.io.Serializable;
import java.util.Objects;
import org.opentripplanner.model.Trip;
import org.opentripplanner.util.time.TimeUtils;

public final class Frequency
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Trip trip;
    private int startTime;
    private int endTime;
    private int headwaySecs;
    private int exactTimes = 0;
    private int labelOnly = 0;

    public Trip getTrip() {
        return this.trip;
    }

    public void setTrip(Trip trip) {
        this.trip = trip;
    }

    public int getStartTime() {
        return this.startTime;
    }

    public void setStartTime(int startTime) {
        this.startTime = startTime;
    }

    public int getEndTime() {
        return this.endTime;
    }

    public void setEndTime(int endTime) {
        this.endTime = endTime;
    }

    public int getHeadwaySecs() {
        return this.headwaySecs;
    }

    public void setHeadwaySecs(int headwaySecs) {
        this.headwaySecs = headwaySecs;
    }

    public int getExactTimes() {
        return this.exactTimes;
    }

    public void setExactTimes(int exactTimes) {
        this.exactTimes = exactTimes;
    }

    public int getLabelOnly() {
        return this.labelOnly;
    }

    public void setLabelOnly(int labelOnly) {
        this.labelOnly = labelOnly;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Frequency frequency = (Frequency)o;
        return this.startTime == frequency.startTime && this.endTime == frequency.endTime && this.headwaySecs == frequency.headwaySecs && Objects.equals(this.trip, frequency.trip);
    }

    public int hashCode() {
        return Objects.hash(this.trip, this.startTime, this.endTime, this.headwaySecs);
    }

    public String toString() {
        return "<Frequency trip=" + this.trip.getId() + " start=" + TimeUtils.timeToStrLong(this.startTime) + " end=" + TimeUtils.timeToStrLong(this.endTime) + ">";
    }
}

